/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.modules;

import java.util.ArrayList;
import java.util.List;
import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.common.precedence.Precedence;
import org.simantics.scl.compiler.constants.Constant;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.macros.MacroRule;
import org.simantics.scl.compiler.elaboration.modules.DeprecatedProperty;
import org.simantics.scl.compiler.elaboration.modules.DerivedProperty;
import org.simantics.scl.compiler.elaboration.modules.PrivateProperty;
import org.simantics.scl.compiler.elaboration.modules.SCLValueProperty;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.codegen.utils.TransientClassBuilder;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.util.Typed;

public final class SCLValue
implements Typed {
    private static final int SIMPLIFIED = 1;
    private static final int INLINE_IN_SIMPLIFICATION = 2;
    private static final int FLAG_MASK = 65535;
    private Name name;
    private Type type;
    private Precedence precedence = Precedence.DEFAULT;
    private IVal value;
    private Expression expression;
    private MacroRule macroRule;
    private int flags = 0;
    private ArrayList<SCLValueProperty> properties = new ArrayList(2);
    public String documentation;
    public long definitionLocation = 9223372034707292160L;

    public SCLValue(Name name) {
        this.name = name;
    }

    public SCLValue(Name name, Constant value) {
        this(name);
        this.setValue(value);
    }

    public Name getName() {
        return this.name;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public void addProperty(SCLValueProperty property) {
        this.properties.add(property);
    }

    public List<SCLValueProperty> getProperties() {
        return this.properties;
    }

    public Precedence getPrecedence() {
        return this.precedence;
    }

    public void setPrecedence(Precedence precedence) {
        this.precedence = precedence;
    }

    public IVal getValue() {
        return this.value;
    }

    public void setValue(IVal value) {
        this.value = value;
        if (this.type == null) {
            this.type = value.getType();
        }
    }

    public Expression getExpression() {
        return this.expression;
    }

    public Expression getSimplifiedExpression(SimplificationContext context) {
        if (this.expression != null && (this.flags & 1) == 0) {
            this.expression = this.expression.simplify(context);
            this.flags |= 1;
        }
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public MacroRule getMacroRule() {
        return this.macroRule;
    }

    public void setMacroRule(MacroRule macroRule) {
        this.macroRule = macroRule;
    }

    public String toString() {
        return this.name.toString();
    }

    private void setFlag(int flagMask, boolean value) {
        this.flags = value ? (this.flags |= flagMask) : (this.flags &= 65535 - flagMask);
    }

    public void setSimplified(boolean value) {
        this.setFlag(1, value);
    }

    public void setInlineInSimplification(boolean value) {
        this.setFlag(2, value);
    }

    public boolean getInlineInSimplification() {
        return (this.flags & 2) != 0;
    }

    public Object realizeValue(TransientClassBuilder classLoader) {
        return this.getValue().realizeValue(classLoader);
    }

    public boolean isPrivate() {
        for (SCLValueProperty property : this.properties) {
            if (property != PrivateProperty.INSTANCE) continue;
            return true;
        }
        return false;
    }

    public String isDeprecated() {
        for (SCLValueProperty property : this.properties) {
            if (!(property instanceof DeprecatedProperty)) continue;
            return ((DeprecatedProperty)property).description;
        }
        return null;
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public boolean isPrivateOrDerived() {
        for (SCLValueProperty property : this.properties) {
            if (property != PrivateProperty.INSTANCE && property != DerivedProperty.INSTANCE) continue;
            return true;
        }
        return false;
    }
}

