/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.element.handler.impl;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Collection;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.Scale;
import org.simantics.g2d.element.handler.Validator;

public class Scaleable
implements Scale,
Validator {
    private static final long serialVersionUID = -4033716332747863703L;
    Double aspectRatio;

    public Scaleable(Double aspectRatio) {
        this.aspectRatio = aspectRatio;
    }

    @Override
    public Double getFixedAspectRatio(IElement e) {
        return this.aspectRatio;
    }

    @Override
    public Point2D getScale(IElement e) {
        AffineTransform at = (AffineTransform)e.getHint(ElementHints.KEY_TRANSFORM);
        return Scaleable._getScale(at);
    }

    @Override
    public void setScale(IElement e, Point2D newScale) {
        Point2D oldScale = this.getScale(e);
        double sx = newScale.getX() / oldScale.getX();
        double sy = newScale.getY() / oldScale.getY();
        AffineTransform at = (AffineTransform)e.getHint(ElementHints.KEY_TRANSFORM);
        at = new AffineTransform(at);
        at.scale(sx, sy);
        e.setHint(ElementHints.KEY_TRANSFORM, at);
    }

    @Override
    public Point2D getMaximumScale(IElement e) {
        return null;
    }

    @Override
    public Point2D getMinimumScale(IElement e) {
        return null;
    }

    private static Point2D _getScale(AffineTransform at) {
        double m00 = at.getScaleX();
        double m11 = at.getScaleY();
        double m10 = at.getShearY();
        double m01 = at.getShearX();
        double sx = Math.sqrt(m00 * m00 + m10 * m10);
        double sy = Math.sqrt(m01 * m01 + m11 * m11);
        return new Point2D.Double(sx, sy);
    }

    @Override
    public void validate(IElement e, ICanvasContext ctx, Collection<Validator.Issue> lst) {
    }
}

