/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.variable;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PropertyInfo;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;

public abstract class ValueProxyVariable
implements Variable {
    protected final Variable proxy;
    protected final Variable parent;

    public ValueProxyVariable(Variable proxy, Variable parent) {
        if (proxy == null) {
            throw new NullPointerException("null proxy");
        }
        if (parent == null) {
            throw new NullPointerException("null parent");
        }
        this.parent = parent;
        this.proxy = proxy;
    }

    @Override
    public <T> T getPropertyValue(ReadGraph graph, String name) throws DatabaseException {
        throw new DatabaseException("Could not resolve property " + name);
    }

    @Override
    public <T> T getPropertyValue(ReadGraph graph, Resource property) throws DatabaseException {
        throw new DatabaseException("Could not resolve property " + NameUtils.getSafeName((ReadGraph)graph, (Resource)property, (boolean)true));
    }

    @Override
    public <T> T getPossiblePropertyValue(ReadGraph graph, String name) throws DatabaseException {
        throw new DatabaseException("Could not resolve property " + name);
    }

    @Override
    public <T> T getPossiblePropertyValue(ReadGraph graph, Resource property) throws DatabaseException {
        throw new DatabaseException("Could not resolve property " + NameUtils.getSafeName((ReadGraph)graph, (Resource)property, (boolean)true));
    }

    @Override
    public <T> T getPropertyValue(ReadGraph graph, String name, Binding binding) throws DatabaseException {
        throw new DatabaseException("Could not resolve property " + name);
    }

    @Override
    public <T> T getPropertyValue(ReadGraph graph, Resource property, Binding binding) throws DatabaseException {
        throw new DatabaseException("Could not resolve property " + NameUtils.getSafeName((ReadGraph)graph, (Resource)property, (boolean)true));
    }

    @Override
    public <T> T getPossiblePropertyValue(ReadGraph graph, String name, Binding binding) throws DatabaseException {
        throw new DatabaseException("Could not resolve property " + name);
    }

    @Override
    public <T> T getPossiblePropertyValue(ReadGraph graph, Resource property, Binding binding) throws DatabaseException {
        return this.proxy.getPossiblePropertyValue(graph, property, binding);
    }

    @Override
    public PropertyInfo getPropertyInfo(ReadGraph graph) throws DatabaseException {
        return this.proxy.getPropertyInfo(graph);
    }

    @Override
    public Resource getIndexRoot(ReadGraph graph) throws DatabaseException {
        return this.proxy.getIndexRoot(graph);
    }

    @Override
    public abstract <T> T getValue(ReadGraph var1) throws DatabaseException;

    @Override
    public abstract <T> T getPossibleValue(ReadGraph var1) throws DatabaseException;

    @Override
    public abstract <T> T getValue(ReadGraph var1, Binding var2) throws DatabaseException;

    @Override
    public abstract <T> T getPossibleValue(ReadGraph var1, Binding var2) throws DatabaseException;

    @Override
    public void setValue(WriteGraph graph, Object value, Binding binding) throws DatabaseException {
        throw new DatabaseException("Not supported");
    }

    @Override
    public void setValue(WriteGraph graph, Object value) throws DatabaseException {
        throw new DatabaseException("Not supported");
    }

    @Override
    public void setPropertyValue(WriteGraph graph, String name, Object value, Binding binding) throws DatabaseException {
        throw new DatabaseException("Not supported");
    }

    @Override
    public void setPropertyValue(WriteGraph graph, Resource property, Object value, Binding binding) throws DatabaseException {
        throw new DatabaseException("Not supported");
    }

    @Override
    public void setPropertyValue(WriteGraph graph, String name, Object value) throws DatabaseException {
        throw new DatabaseException("Not supported");
    }

    @Override
    public void setPropertyValue(WriteGraph graph, Resource property, Object value) throws DatabaseException {
        throw new DatabaseException("Not supported");
    }

    @Override
    public Variable getChild(ReadGraph graph, String name) throws DatabaseException {
        throw new DatabaseException("Could not resolve child " + name);
    }

    @Override
    public Variable getPossibleChild(ReadGraph graph, String name) throws DatabaseException {
        return null;
    }

    @Override
    public Variable getProperty(ReadGraph graph, String name) throws DatabaseException {
        throw new DatabaseException("Could not resolve property " + name);
    }

    @Override
    public Variable getProperty(ReadGraph graph, Resource property) throws DatabaseException {
        throw new DatabaseException("Could not resolve property " + NameUtils.getSafeName((ReadGraph)graph, (Resource)property, (boolean)true));
    }

    @Override
    public Variable getPossibleProperty(ReadGraph graph, String name) throws DatabaseException {
        return null;
    }

    @Override
    public Variable getPossibleProperty(ReadGraph graph, Resource property) throws DatabaseException {
        return null;
    }

    @Override
    public Collection<Variable> browseChildren(ReadGraph graph) throws DatabaseException {
        return this.getChildren(graph);
    }

    @Override
    public Collection<Variable> getChildren(ReadGraph graph) throws DatabaseException {
        return Collections.emptyList();
    }

    @Override
    public Collection<Variable> browseProperties(ReadGraph graph) throws DatabaseException {
        return this.getProperties(graph);
    }

    @Override
    public Collection<Variable> getProperties(ReadGraph graph) throws DatabaseException {
        return Collections.emptyList();
    }

    @Override
    public Collection<Variable> getProperties(ReadGraph graph, String classification) throws DatabaseException {
        return Collections.emptyList();
    }

    @Override
    public Collection<Variable> getProperties(ReadGraph graph, Resource classification) throws DatabaseException {
        return Collections.emptyList();
    }

    @Override
    public Variable browse(ReadGraph graph, String suffix) throws DatabaseException {
        if (suffix.isEmpty()) {
            return this;
        }
        throw new DatabaseException("Could not browse with suffix '" + suffix + "'");
    }

    @Override
    public Variable browsePossible(ReadGraph graph, String suffix) throws DatabaseException {
        if (suffix.isEmpty()) {
            return this;
        }
        return null;
    }

    @Override
    public Variable browse(ReadGraph graph, Resource config) throws DatabaseException {
        throw new DatabaseException("Could not browse '" + NameUtils.getSafeName((ReadGraph)graph, (Resource)config, (boolean)true) + "'");
    }

    @Override
    public Variable browsePossible(ReadGraph graph, Resource config) throws DatabaseException {
        return null;
    }

    @Override
    public <T> T getInterface(ReadGraph graph, Class<T> clazz) throws DatabaseException {
        return null;
    }

    @Override
    public <T> T adapt(ReadGraph graph, Class<T> clazz) throws DatabaseException {
        return null;
    }

    @Override
    public <T> T adaptPossible(ReadGraph graph, Class<T> clazz) throws DatabaseException {
        return null;
    }

    @Override
    public abstract String getURI(ReadGraph var1) throws DatabaseException;

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    @Override
    public Variable resolve(ReadGraph graph, RVI.RVIPart part) throws DatabaseException {
        throw new DatabaseException("not supported");
    }

    @Override
    public Variable resolvePossible(ReadGraph graph, RVI.RVIPart part) throws DatabaseException {
        return null;
    }

    @Override
    public abstract String getName(ReadGraph var1) throws DatabaseException;

    @Override
    public String getLabel(ReadGraph graph) throws DatabaseException {
        throw new DatabaseException("not supported");
    }

    @Override
    public abstract Datatype getDatatype(ReadGraph var1) throws DatabaseException;

    @Override
    public Datatype getPossibleDatatype(ReadGraph graph) throws DatabaseException {
        try {
            return this.getDatatype(graph);
        }
        catch (DatabaseException databaseException) {
            return null;
        }
    }

    @Override
    public Variable getPredicate(ReadGraph graph) throws DatabaseException {
        throw new DatabaseException("not supported");
    }

    @Override
    public Variable getPossiblePredicate(ReadGraph graph) throws DatabaseException {
        throw new DatabaseException("not supported");
    }

    @Override
    public Resource getPredicateResource(ReadGraph graph) throws DatabaseException {
        throw new DatabaseException("not supported");
    }

    @Override
    public Resource getPossiblePredicateResource(ReadGraph graph) throws DatabaseException {
        try {
            return this.getPredicateResource(graph);
        }
        catch (DatabaseException databaseException) {
            return null;
        }
    }

    @Override
    public Variable getParent(ReadGraph graph) throws DatabaseException {
        return this.parent;
    }

    @Override
    public Resource getRepresents(ReadGraph graph) throws DatabaseException {
        throw new DatabaseException("no resource representation");
    }

    @Override
    public Resource getPossibleRepresents(ReadGraph graph) throws DatabaseException {
        return null;
    }

    @Override
    public Resource getType(ReadGraph graph) throws DatabaseException {
        throw new DatabaseException("not supported");
    }

    @Override
    public Resource getPossibleType(ReadGraph graph) throws DatabaseException {
        return null;
    }

    @Override
    public Resource getType(ReadGraph graph, Resource baseType) throws DatabaseException {
        throw new DatabaseException("not supported");
    }

    @Override
    public Resource getPossibleType(ReadGraph graph, Resource baseType) throws DatabaseException {
        return null;
    }

    @Override
    public abstract RVI getRVI(ReadGraph var1) throws DatabaseException;

    @Override
    public RVI getPossibleRVI(ReadGraph graph) throws DatabaseException {
        try {
            return this.getRVI(graph);
        }
        catch (DatabaseException databaseException) {
            return null;
        }
    }

    @Override
    public Variables.Role getRole(ReadGraph graph) throws DatabaseException {
        return Variables.Role.PROPERTY;
    }

    @Override
    public Variables.Role getPossibleRole(ReadGraph graph) throws DatabaseException {
        return Variables.Role.PROPERTY;
    }

    @Override
    public Set<String> getClassifications(ReadGraph graph) throws DatabaseException {
        return Collections.emptySet();
    }

    @Override
    public abstract Variant getVariantValue(ReadGraph var1) throws DatabaseException;
}

