/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.ui.actions;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.db.request.Write;
import org.simantics.layer0.Layer0;
import org.simantics.ui.SimanticsUI;

public class NewDocumentFolder
implements ActionFactory {
    Resource folderType;
    Resource relation;

    public NewDocumentFolder(ReadGraph graph, String folderTypeUri, String relationUri) throws DatabaseException {
        this.folderType = graph.getResource(folderTypeUri);
        this.relation = graph.getResource(relationUri);
    }

    public Runnable create(Object target) {
        if (!(target instanceof Resource)) {
            return null;
        }
        final Resource resource = (Resource)target;
        return new Runnable(){

            @Override
            public void run() {
                SimanticsUI.getSession().asyncRequest((Write)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        graph.markUndoPoint();
                        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                        String name = NameUtils.findFreshName((ReadGraph)graph, (String)"Folder", (Resource)resource, (Resource)(this).NewDocumentFolder.this.relation);
                        Resource folder = graph.newResource();
                        graph.claim(folder, l0.InstanceOf, (this).NewDocumentFolder.this.folderType);
                        graph.claimLiteral(folder, l0.HasName, (Object)name);
                        graph.claim(resource, (this).NewDocumentFolder.this.relation, folder);
                    }
                });
            }
        };
    }
}

