/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.trend;

import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.browsing.ui.swt.SingleSelectionInputSource;
import org.simantics.browsing.ui.swt.widgets.GraphExplorerComposite;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupportImpl;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;
import org.simantics.jfreechart.chart.properties.AdjustableTab;
import org.simantics.jfreechart.chart.properties.xyline.AxisAndVariablesExplorerComposite;
import org.simantics.jfreechart.chart.properties.xyline.AxisPropertyComposite;
import org.simantics.sysdyn.JFreeChartResource;
import org.simantics.sysdyn.ui.trend.SensitivitySeriesPropertyComposite;
import org.simantics.ui.SimanticsUI;
import org.simantics.utils.datastructures.ArrayMap;
import org.simantics.utils.ui.AdaptionUtils;

public class SensitivityChartAxisAndVariablesTab
extends AdjustableTab {
    private GraphExplorerComposite explorer;
    private ScrolledComposite propertyContainer;
    private WidgetSupportImpl additionalSupport = new WidgetSupportImpl();

    public SensitivityChartAxisAndVariablesTab(Object id) {
        super(id);
    }

    private void updateSelection(ISessionContext context) {
        ISelectionProvider selectionProvider = (ISelectionProvider)this.explorer.getAdapter(ISelectionProvider.class);
        IStructuredSelection selection = (IStructuredSelection)selectionProvider.getSelection();
        final Resource resource = (Resource)AdaptionUtils.adaptToSingle((Object)selection, Resource.class);
        if (resource == null) {
            return;
        }
        String typeUri = null;
        try {
            typeUri = (String)SimanticsUI.getSession().syncRequest((Read)new Read<String>(){

                public String perform(ReadGraph graph) throws DatabaseException {
                    JFreeChartResource jfree = JFreeChartResource.getInstance((ReadGraph)graph);
                    if (graph.isInstanceOf(resource, jfree.Axis)) {
                        return graph.getURI(jfree.Axis);
                    }
                    if (graph.isInstanceOf(resource, jfree.Series)) {
                        return graph.getURI(jfree.Series);
                    }
                    return null;
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        if (typeUri != null) {
            Control[] controlArray = this.propertyContainer.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                child.dispose();
                ++n2;
            }
            if (typeUri.equals("http://www.simantics.org/JFreeChart-1.0/Axis")) {
                AxisPropertyComposite apc = new AxisPropertyComposite((Composite)this.propertyContainer, context, (WidgetSupport)this.additionalSupport, 0, this.isVertical());
                this.propertyContainer.setContent((Control)apc);
                Point size = apc.computeSize(-1, -1);
                this.propertyContainer.setMinSize(size);
            } else if (typeUri.equals("http://www.simantics.org/JFreeChart-1.0/Series")) {
                SensitivitySeriesPropertyComposite spc = new SensitivitySeriesPropertyComposite((Composite)this.propertyContainer, context, (WidgetSupport)this.additionalSupport, 0);
                this.propertyContainer.setContent((Control)spc);
                Point size = spc.computeSize(-1, -1);
                this.propertyContainer.setMinSize(size);
            }
        }
        this.additionalSupport.fireInput(context, (Object)selection);
    }

    protected void createAndAddControls(Composite body, IWorkbenchSite site, final ISessionContext context, WidgetSupport support) {
        this.composite = new Composite(body, 0);
        this.explorer = new AxisAndVariablesExplorerComposite((Map)ArrayMap.keys((Object[])new String[]{"displaySelectors", "displayFilter"}).values(new Object[]{false, false}), site, this.composite, support, 67588);
        this.explorer.setBrowseContexts(new String[]{"http://www.simantics.org/JFreeChart-1.0/ChartAxisAndVariablesBrowseContext"});
        this.explorer.setInputSource((GraphExplorerComposite.InputSource)new SingleSelectionInputSource(Resource.class));
        this.explorer.getExplorer().setAutoExpandLevel(2);
        this.explorer.finish();
        ((Tree)this.explorer.getExplorerControl()).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SensitivityChartAxisAndVariablesTab.this.updateSelection(context);
            }
        });
        this.propertyContainer = new ScrolledComposite(this.composite, 768);
        this.propertyContainer.setExpandHorizontal(true);
        this.propertyContainer.setExpandVertical(true);
    }

    protected void createControlLayoutVertical() {
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.composite);
        GridLayoutFactory.fillDefaults().numColumns(1).margins(3, 3).applyTo(this.composite);
        GridDataFactory.fillDefaults().hint(220, -1).grab(false, true).applyTo((Control)this.explorer);
        GridDataFactory.fillDefaults().span(1, 1).hint(-1, 210).grab(true, false).applyTo((Control)this.propertyContainer);
        GridLayoutFactory.fillDefaults().applyTo((Composite)this.propertyContainer);
    }

    protected void createControlLayoutHorizontal(boolean wideScreen) {
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.composite);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(3, 3).applyTo(this.composite);
        GridDataFactory.fillDefaults().hint(250, -1).grab(false, true).applyTo((Control)this.explorer);
        GridDataFactory.fillDefaults().span(1, 2).hint(-1, -1).grab(true, true).applyTo((Control)this.propertyContainer);
        GridLayoutFactory.fillDefaults().applyTo((Composite)this.propertyContainer);
    }
}

