/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.structure;

import java.util.HashMap;
import java.util.List;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.graphviz.Edge;
import org.simantics.graphviz.Graph;
import org.simantics.graphviz.IGraph;
import org.simantics.graphviz.Identifiable;
import org.simantics.graphviz.Node;
import org.simantics.modeling.ModelingResources;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.ui.structure.DependencyGraphRequest;
import org.simantics.sysdyn.utils.LoopUtils;
import org.simantics.utils.datastructures.MapList;

public class LoopGraphRequest
extends DependencyGraphRequest {
    MapList<Resource, Edge> edges;

    public LoopGraphRequest(Resource root) {
        super(root, 999, false);
    }

    @Override
    public Graph perform(ReadGraph g) throws DatabaseException {
        this.nodes = new HashMap();
        Graph graph = new Graph();
        graph.setRankdir("LR");
        ModelingResources mr = ModelingResources.getInstance((ReadGraph)g);
        Resource element = g.getPossibleObject(this.root, mr.ElementToComponent);
        if (element != null) {
            this.root = element;
        }
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)g);
        if (g.isInstanceOf(this.root, sr.IndependentVariable) || g.isInstanceOf(this.root, sr.Input)) {
            List loops = LoopUtils.getLoops((ReadGraph)g, (Resource)this.root);
            this.setRoot(g, (IGraph)graph, this.root);
            this.edges = new MapList();
            for (List loop : loops) {
                Resource prev = null;
                for (Resource r : loop) {
                    if (!this.nodes.containsKey(r)) {
                        Node n = new Node((IGraph)graph, this.getName(g, r));
                        this.setShape(g, r, n);
                        this.nodes.put(r, n);
                    }
                    if (prev != null) {
                        this.claimEdge(g, (IGraph)graph, prev, r);
                    }
                    prev = r;
                }
                if (prev == null || loop.get(0) == null) continue;
                this.claimEdge(g, (IGraph)graph, prev, (Resource)loop.get(0));
            }
        }
        return graph;
    }

    private void claimEdge(ReadGraph g, IGraph graph, Resource tail, Resource head) throws DatabaseException {
        for (Edge e : this.edges.getValues((Object)tail)) {
            if (!((Node)e.getHead()).get("label").equals(this.getName(g, head))) continue;
            String arrowsize = e.get("arrowsize");
            if (arrowsize == null) {
                arrowsize = "1.0";
            }
            e.setArrowsize(Math.min(2.2, Math.sqrt(Double.valueOf(arrowsize) + 0.8)));
            return;
        }
        for (Edge e : this.edges.getValues((Object)head)) {
            if (!((Node)e.getHead()).get("label").equals(this.getName(g, tail))) continue;
            e.setDir("both");
            return;
        }
        this.edges.add((Object)tail, (Object)new Edge(graph, (Identifiable)this.nodes.get(tail), (Identifiable)this.nodes.get(head)));
    }
}

