/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.properties.widgets;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.simantics.browsing.ui.swt.widgets.Button;
import org.simantics.browsing.ui.swt.widgets.WidgetImpl;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactory;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactoryImpl;
import org.simantics.browsing.ui.swt.widgets.impl.SelectionListenerImpl;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.modeling.ModelingResources;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.utils.datastructures.Quad;

public class ValveTextLocationGroup
extends WidgetImpl {
    Group group;
    Button top;
    Button bottom;
    Button left;
    Button right;

    public ValveTextLocationGroup(Composite parent, ISessionContext context, WidgetSupport support, int style) {
        super(support);
        this.group = new Group(parent, 0);
        this.group.setText("Text location");
        GridDataFactory.fillDefaults().applyTo((Control)this.group);
        GridLayoutFactory.fillDefaults().margins(3, 3).applyTo((Composite)this.group);
        this.top = new Button((Composite)this.group, support, 16);
        this.top.setText("Top");
        this.top.setSelectionFactory((ReadFactory)new LocationSelectionFactory(this.top, "http://www.simantics.org/Sysdyn-1.1/Top"));
        this.top.addSelectionListener((SelectionListener)new LocationSelectionListener(context, "http://www.simantics.org/Sysdyn-1.1/Top"));
        this.bottom = new Button((Composite)this.group, support, 16);
        this.bottom.setText("Bottom");
        this.bottom.setSelectionFactory((ReadFactory)new LocationSelectionFactory(this.bottom, "http://www.simantics.org/Sysdyn-1.1/Bottom", true));
        this.bottom.addSelectionListener((SelectionListener)new LocationSelectionListener(context, "http://www.simantics.org/Sysdyn-1.1/Bottom"));
        this.left = new Button((Composite)this.group, support, 16);
        this.left.setText("Left");
        this.left.setSelectionFactory((ReadFactory)new LocationSelectionFactory(this.left, "http://www.simantics.org/Sysdyn-1.1/Left"));
        this.left.addSelectionListener((SelectionListener)new LocationSelectionListener(context, "http://www.simantics.org/Sysdyn-1.1/Left"));
        this.right = new Button((Composite)this.group, support, 16);
        this.right.setText("Right");
        this.right.setSelectionFactory((ReadFactory)new LocationSelectionFactory(this.right, "http://www.simantics.org/Sysdyn-1.1/Right"));
        this.right.addSelectionListener((SelectionListener)new LocationSelectionListener(context, "http://www.simantics.org/Sysdyn-1.1/Right"));
    }

    public void setInput(ISessionContext context, Object input) {
        this.top.setInput(context, input);
        this.bottom.setInput(context, input);
        this.left.setInput(context, input);
        this.right.setInput(context, input);
    }

    public Control getControl() {
        return this.group;
    }

    private class LocationSelectionFactory
    extends ReadFactoryImpl<Resource, Boolean> {
        boolean defaultSelected;
        String uri;
        Button button;

        public LocationSelectionFactory(Button button, String uri) {
            this(button, uri, false);
        }

        public LocationSelectionFactory(Button button, String uri, boolean defaultSelected) {
            this.uri = uri;
            this.defaultSelected = defaultSelected;
            this.button = button;
        }

        public Object getIdentity(Object inputContents) {
            return new Quad((Object)this.button, (Object)this.uri, (Object)this.defaultSelected, ((Object)((Object)this)).getClass());
        }

        public Boolean perform(ReadGraph graph, Resource valve) throws DatabaseException {
            SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
            ModelingResources mr = ModelingResources.getInstance((ReadGraph)graph);
            if (!graph.isInstanceOf(valve, sr.Valve)) {
                return Boolean.FALSE;
            }
            Resource symbol = graph.getPossibleObject(valve, mr.ComponentToElement);
            if (symbol == null) {
                return Boolean.FALSE;
            }
            Resource location = graph.getPossibleObject(symbol, sr.ValveSymbol_textLocation);
            if (location == null) {
                return this.defaultSelected;
            }
            return location.equals(graph.getResource(this.uri));
        }
    }

    private class LocationSelectionListener
    extends SelectionListenerImpl<Resource> {
        String uri;

        public LocationSelectionListener(ISessionContext context, String uri) {
            super(context);
            this.uri = uri;
        }

        public void apply(WriteGraph graph, Resource valve) throws DatabaseException {
            SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
            ModelingResources mr = ModelingResources.getInstance((ReadGraph)graph);
            if (!graph.isInstanceOf(valve, sr.Valve)) {
                return;
            }
            Resource symbol = graph.getPossibleObject(valve, mr.ComponentToElement);
            if (symbol == null) {
                return;
            }
            if (graph.hasStatement(symbol, sr.ValveSymbol_textLocation)) {
                graph.deny(symbol, sr.ValveSymbol_textLocation);
            }
            graph.claim(symbol, sr.ValveSymbol_textLocation, graph.getResource(this.uri));
        }
    }
}

