/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.handlers.imports;

import java.io.File;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.DatabaseJob;
import org.simantics.browsing.ui.common.node.AbstractNode;
import org.simantics.db.Resource;
import org.simantics.sysdyn.ui.Activator;
import org.simantics.sysdyn.ui.utils.imports.ImportUtilsUI;
import org.simantics.utils.ui.AdaptionUtils;

public class ImportModuleHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection sel = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        AbstractNode node = (AbstractNode)AdaptionUtils.adaptToSingle((Object)sel, AbstractNode.class);
        if (node == null) {
            return null;
        }
        final Resource model = (Resource)node.data;
        Shell shell = HandlerUtil.getActiveShellChecked((ExecutionEvent)event);
        FileDialog fd = new FileDialog(shell, 4096);
        fd.setText("Import Module");
        String path = Activator.getDefault().getPreferenceStore().getString(ImportUtilsUI.IMPORTMODULETPATH);
        if (path.isEmpty() || !new File(path).exists()) {
            path = Platform.getLocation().toOSString();
        }
        fd.setFilterPath(path);
        String[] filterExt = new String[]{"*.sysdynModule; *.tg", "*.*"};
        fd.setFilterExtensions(filterExt);
        final String selected = fd.open();
        if (selected == null) {
            return null;
        }
        DatabaseJob job = new DatabaseJob("Import module"){

            protected IStatus run(IProgressMonitor monitor) {
                IStatus status = ImportUtilsUI.importModuleFile(model, selected, monitor);
                return status;
            }
        };
        job.setUser(true);
        job.schedule();
        return null;
    }
}

