/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.elements;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.diagram.elements.DiagramNodeUtil;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.modeling.ModelingResources;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.ParentNode;
import org.simantics.scenegraph.g2d.IG2DNode;
import org.simantics.scenegraph.g2d.nodes.ConnectionNode;
import org.simantics.scenegraph.g2d.nodes.spatial.RTreeNode;
import org.simantics.scenegraph.utils.NodeUtil;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.ui.elements.HoverShapeNode;
import org.simantics.ui.SimanticsUI;

public class LoopNode
extends HoverShapeNode {
    public static Color HIGHLIGHT_COLOR = Color.decode("#ff5fbf");
    private boolean selected = false;
    private static final long serialVersionUID = 6173159124691715569L;

    public void render(Graphics2D g2d) {
        super.render(g2d);
        boolean selected = NodeUtil.isSelected((INode)this, (int)1);
        if (selected || this.selected != selected) {
            this.selected = selected;
            this.setLoopItemsSelected();
        }
    }

    private void setLoopItemsSelected() {
        List<Resource> loopItems = this.getAllLoopItems();
        RTreeNode diagramNode = (RTreeNode)NodeUtil.getPossibleNearestParentOfType((INode)this, RTreeNode.class);
        if (diagramNode == null) {
            return;
        }
        Collection children = diagramNode.getNodes();
        for (IG2DNode n : children) {
            INode child = LoopNode.getNodeOfPossibleLoopComponentNode(n);
            if (!(child instanceof ILoopComponentNode)) continue;
            ILoopComponentNode ln = (ILoopComponentNode)child;
            IElement e = DiagramNodeUtil.getElement((IG2DNode)((IG2DNode)child.getParent()));
            Resource r = (Resource)e.getHint(ElementHints.KEY_OBJECT);
            ln.setLoopSelected(this, NodeUtil.isSelected((INode)this, (int)1) && loopItems.contains(r));
        }
    }

    private static INode getNodeOfPossibleLoopComponentNode(IG2DNode n2) {
        Collection nodeIds = ((ParentNode)n2).getNodeIds();
        for (String id : nodeIds) {
            if (!"text".equals(id) && !id.startsWith("flow_")) continue;
            return ((ParentNode)n2).getNode(id);
        }
        if (n2 instanceof ConnectionNode) {
            for (IG2DNode n2 : ((ConnectionNode)n2).getNodes()) {
                if (!(n2 instanceof ParentNode)) continue;
                nodeIds = ((ParentNode)n2).getNodeIds();
                for (String id : nodeIds) {
                    if (!id.startsWith("edge_")) continue;
                    return ((ParentNode)n2).getNode(id);
                }
            }
        }
        return null;
    }

    private List<Resource> getAllLoopItems() {
        IElement loopElement = DiagramNodeUtil.getElement((IG2DNode)this);
        final Resource loopSymbolResource = (Resource)loopElement.getHint(ElementHints.KEY_OBJECT);
        List loopItems = Collections.emptyList();
        try {
            loopItems = (List)SimanticsUI.getSession().syncRequest((Read)new Read<List<Resource>>(){

                public List<Resource> perform(ReadGraph graph) throws DatabaseException {
                    ModelingResources mod = ModelingResources.getInstance((ReadGraph)graph);
                    SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                    Resource loopComponentResource = graph.getPossibleObject(loopSymbolResource, mod.ElementToComponent);
                    if (loopComponentResource == null) {
                        return Collections.emptyList();
                    }
                    Resource loopResource = graph.getPossibleObject(loopComponentResource, sr.Loop_Items);
                    if (loopResource == null) {
                        return Collections.emptyList();
                    }
                    List loopItems = ListUtils.toPossibleList((ReadGraph)graph, (Resource)loopResource);
                    if (loopItems == null) {
                        return Collections.emptyList();
                    }
                    ArrayList<Resource> dependencyItems = new ArrayList<Resource>();
                    int i = 0;
                    while (i < loopItems.size()) {
                        boolean skipBackwardFlows = false;
                        Collection forwardDependencies = graph.getObjects((Resource)loopItems.get(i), sr.Variable_isTailOf);
                        Collection shadows = graph.getObjects((Resource)loopItems.get(i), sr.Shadow_original_Inverse);
                        for (Resource shadow : shadows) {
                            forwardDependencies.addAll(graph.getObjects(shadow, sr.Variable_isTailOf));
                        }
                        for (Resource dependency : forwardDependencies) {
                            Resource dependingVariable = graph.getSingleObject(dependency, sr.Variable_HasHead);
                            if (!dependingVariable.equals(loopItems.get((i + 1) % loopItems.size())) || graph.isInstanceOf(dependency, sr.Flow) && graph.isInstanceOf((Resource)loopItems.get(i), sr.Stock)) continue;
                            skipBackwardFlows = true;
                            dependencyItems.add(graph.getSingleObject(dependency, mod.ConnectionToDiagramConnection));
                            break;
                        }
                        if (!skipBackwardFlows) {
                            Collection backwardFlows = graph.getObjects((Resource)loopItems.get(i), sr.Variable_isHeadOf);
                            for (Resource flow : backwardFlows) {
                                Resource dependingVariable;
                                if (!graph.isInstanceOf(flow, sr.Flow) || !(dependingVariable = graph.getSingleObject(flow, sr.Variable_HasTail)).equals(loopItems.get((i + 1) % loopItems.size())) || !graph.isInstanceOf(dependingVariable, sr.Stock)) continue;
                                dependencyItems.add(graph.getSingleObject(flow, mod.ConnectionToDiagramConnection));
                                break;
                            }
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < loopItems.size()) {
                        loopItems.set(i, graph.getPossibleObject((Resource)loopItems.get(i), mod.ComponentToElement));
                        ++i;
                    }
                    loopItems.addAll(dependencyItems);
                    return loopItems;
                }
            });
        }
        catch (DatabaseException e1) {
            e1.printStackTrace();
        }
        return loopItems;
    }

    public static interface ILoopComponentNode {
        public void setLoopSelected(LoopNode var1, boolean var2);
    }
}

