/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.editor;

import java.util.ArrayList;
import java.util.Arrays;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.diagram.content.ConnectionUtil;
import org.simantics.diagram.content.ResourceTerminal;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.g2d.connection.IConnectionAdvisor;
import org.simantics.g2d.diagram.handler.Topology;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.impl.StaticObjectAdapter;
import org.simantics.structural2.modelingRules.CPIgnore;
import org.simantics.structural2.modelingRules.ConnectionJudgement;
import org.simantics.structural2.modelingRules.ConnectionJudgementType;
import org.simantics.structural2.modelingRules.IConnectionPoint;
import org.simantics.structural2.modelingRules.IModelingRules;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.ui.elements.CloudFactory;

public class SysdynConnectionAdvisor
implements IConnectionAdvisor {
    IModelingRules modelingRules;
    RequestProcessor processor;

    public SysdynConnectionAdvisor(IModelingRules modelingRules, RequestProcessor processor) {
        this.modelingRules = modelingRules;
        this.processor = processor;
    }

    IConnectionPoint getConnectionPoint(ReadGraph g, IElement element, Topology.Terminal term) throws DatabaseException {
        Object obj = null;
        if (element != null) {
            obj = ElementUtils.getObject((IElement)element);
        }
        if (obj instanceof Resource) {
            Resource elementResource = (Resource)obj;
            return ConnectionUtil.toConnectionPoint((ReadGraph)g, (Resource)elementResource, (Topology.Terminal)term);
        }
        if (element.getElementClass().containsClass(CloudFactory.CloudSceneGraph.class)) {
            return CPIgnore.NULL_INSTANCE;
        }
        return null;
    }

    public Object canBeConnected(Object backend, final IElement element1, final Topology.Terminal term1, final IElement element2, final Topology.Terminal term2) {
        try {
            if (backend == null) {
                backend = this.processor;
            }
            return ((RequestProcessor)backend).syncRequest((Read)new Read<Object>(){

                public Object perform(ReadGraph g) throws DatabaseException {
                    if (element1 != null && term1 != null && element2 != null && term2 != null) {
                        StaticObjectAdapter soa = (StaticObjectAdapter)element1.getElementClass().getSingleItem(StaticObjectAdapter.class);
                        Resource startElementResource = (Resource)soa.adapt(Resource.class);
                        Object r = ElementUtils.getObject((IElement)element2);
                        if (r == null || !(r instanceof Resource)) {
                            return null;
                        }
                        Resource endElementResource = (Resource)r;
                        DiagramResource dr = DiagramResource.getInstance((ReadGraph)g);
                        Resource terminal2 = ((ResourceTerminal)term2).getResource();
                        SysdynResource sr = SysdynResource.getInstance((ReadGraph)g);
                        Resource connectionPoint = g.getPossibleObject(terminal2, dr.HasConnectionPoint);
                        if (connectionPoint == null || !g.isSubrelationOf(connectionPoint, sr.IsHeadOfTerminal)) {
                            return null;
                        }
                        if (g.isInstanceOf(endElementResource, sr.InputSymbol)) {
                            if (!g.isInheritedFrom(startElementResource, sr.ModuleSymbol)) {
                                return null;
                            }
                            if (g.getObjects(endElementResource, sr.IsHeadOfTerminal).size() > 0) {
                                return null;
                            }
                        }
                    }
                    ArrayList<IConnectionPoint> cps = new ArrayList<IConnectionPoint>();
                    cps.add(SysdynConnectionAdvisor.this.getConnectionPoint(g, element1, term1));
                    if (element2 != null) {
                        cps.add(SysdynConnectionAdvisor.this.getConnectionPoint(g, element2, term2));
                    }
                    ConnectionJudgement judgement = SysdynConnectionAdvisor.this.modelingRules.judgeConnection(g, cps);
                    if (judgement.type == ConnectionJudgementType.LEGAL) {
                        return judgement;
                    }
                    return null;
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean canBeginConnection(Object backend, final IElement element, final Topology.Terminal term) {
        try {
            if (backend == null) {
                backend = this.processor;
            }
            return (Boolean)((RequestProcessor)backend).syncRequest((Read)new Read<Boolean>(){

                public Boolean perform(ReadGraph g) throws DatabaseException {
                    if (SysdynConnectionAdvisor.this.modelingRules.judgeConnection((ReadGraph)g, Arrays.asList(new IConnectionPoint[]{SysdynConnectionAdvisor.this.getConnectionPoint((ReadGraph)g, (IElement)element, (Topology.Terminal)term)})).type != ConnectionJudgementType.ILLEGAL) {
                        return true;
                    }
                    return false;
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            return false;
        }
    }
}

