/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.browser.nodes;

import java.util.Collection;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.simantics.DatabaseJob;
import org.simantics.browsing.ui.common.node.AbstractNode;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.modeling.ui.diagramEditor.DiagramEditor;
import org.simantics.sysdyn.ui.utils.SysdynWorkbenchUtils;
import org.simantics.ui.SimanticsUI;
import org.simantics.ui.utils.ResourceAdaptionUtils;
import org.simantics.utils.ui.AdaptionUtils;

public class ExportTester
extends PropertyTester {
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        Resource inputResource = ResourceAdaptionUtils.toSingleResource((Object)receiver);
        if (inputResource == null) {
            Collection a = AdaptionUtils.adaptToCollection((Object)receiver, AbstractNode.class);
            if (a.size() > 1) {
                return false;
            }
            if (a.size() == 1) {
                inputResource = (Resource)((AbstractNode)a.iterator().next()).data;
            }
        }
        if (inputResource == null) {
            IWorkbenchPage page = SysdynWorkbenchUtils.getActivePageOfEditor();
            IEditorPart editor = page.getActiveEditor();
            if (editor instanceof DiagramEditor) {
                inputResource = ((DiagramEditor)editor).getInputResource();
            } else {
                return false;
            }
        }
        final Resource resource = inputResource;
        Session session = SimanticsUI.peekSession();
        if (session == null) {
            return false;
        }
        if (DatabaseJob.inProgress()) {
            return false;
        }
        try {
            return (Boolean)session.syncRequest((Read)new Read<Boolean>(){

                public Boolean perform(ReadGraph g) throws DatabaseException {
                    if (g.sync((ReadInterface)new PossibleModel(resource)) != null) {
                        return true;
                    }
                    return false;
                }
            });
        }
        catch (DatabaseException e) {
            return false;
        }
    }
}

