/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.svg;

import java.io.File;
import java.io.IOException;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.stubs.G2DResource;
import org.simantics.diagram.synchronization.graph.AddElement;
import org.simantics.image2.ontology.ImageResource;
import org.simantics.layer0.Layer0;
import org.simantics.layer0.utils.direct.GraphUtils;
import org.simantics.utils.FileUtils;

public class CreateSVGElement {
    public static void createSVGElement(WriteGraph g, Resource diagram, String suffix, byte[] data, double mposX, double mposY) throws DatabaseException {
        CreateSVGElement.createSVGElement(g, diagram, suffix, data, mposX, mposY);
    }

    public static Resource createSVGElementR(WriteGraph g, Resource diagram, String suffix, byte[] data, double mposX, double mposY) throws DatabaseException {
        Resource element;
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)g);
        ImageResource IMAGE = ImageResource.getInstance((ReadGraph)g);
        G2DResource G2D = G2DResource.getInstance((ReadGraph)g);
        if ("svg".equals(suffix)) {
            Resource transform = GraphUtils.create((WriteGraph)g, (Resource[])new Resource[]{L0.InstanceOf, G2D.Transform});
            g.claimValue(transform, (Object)new double[]{1.0, 0.0, 0.0, 1.0, mposX, mposY}, (Binding)Bindings.DOUBLE_ARRAY);
            element = GraphUtils.create((WriteGraph)g, (Object[])new Object[]{L0.InstanceOf, DIA.SVGElement, G2D.HasSVGDocument, new String(data), DIA.HasTransform, transform});
            AddElement.claimFreshElementName((WriteGraph)g, (Resource)diagram, (Resource)element);
        } else if ("png".equals(suffix)) {
            Resource transform = GraphUtils.create((WriteGraph)g, (Resource[])new Resource[]{L0.InstanceOf, G2D.Transform});
            g.claimValue(transform, (Object)new double[]{1.0, 0.0, 0.0, 1.0, mposX, mposY}, (Binding)Bindings.DOUBLE_ARRAY);
            Resource image = g.newResource();
            g.claim(image, L0.InstanceOf, IMAGE.PngImage);
            g.claimValue(image, (Object)data, (Binding)Bindings.BYTE_ARRAY);
            element = GraphUtils.create((WriteGraph)g, (Resource[])new Resource[]{L0.InstanceOf, DIA.RasterElement, G2D.HasRasterImage, image, DIA.HasTransform, transform});
            AddElement.claimFreshElementName((WriteGraph)g, (Resource)diagram, (Resource)element);
        } else {
            throw new DatabaseException("Unknown image format " + suffix);
        }
        OrderedSetUtils.addFirst((WriteGraph)g, (Resource)diagram, (Resource)element);
        g.claim(diagram, L0.ConsistsOf, element);
        return element;
    }

    public static void importSVGElement(WriteGraph graph, Resource diagram, File file, double posX, double posY) throws DatabaseException, IOException {
        CreateSVGElement.importSVGElementR(graph, diagram, file, posX, posY);
    }

    public static Resource importSVGElementR(WriteGraph graph, Resource diagram, File file, double posX, double posY) throws DatabaseException, IOException {
        byte[] data = FileUtils.readFile((File)file);
        return CreateSVGElement.createSVGElementR(graph, diagram, CreateSVGElement.suffix(file.getName()), data, posX, posY);
    }

    private static String suffix(String fileName) {
        int len = fileName.length();
        if (len < 3) {
            return null;
        }
        return fileName.substring(len - 3, len).toLowerCase();
    }
}

