/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.osgi.framework.Bundle;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.request.IndexRoot;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.SubgraphExtent;
import org.simantics.db.layer0.adapter.impl.DefaultCopyHandler;
import org.simantics.db.layer0.adapter.impl.DefaultPasteHandler;
import org.simantics.db.layer0.adapter.impl.DefaultPasteImportAdvisor;
import org.simantics.db.layer0.util.ClipboardUtils;
import org.simantics.db.layer0.util.DomainProcessorState;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.util.ModelTransferableGraphSource;
import org.simantics.db.layer0.util.ModelTransferableGraphSourceRequest;
import org.simantics.db.layer0.util.SimanticsClipboardBuilder;
import org.simantics.db.layer0.util.SimanticsClipboardImpl;
import org.simantics.db.layer0.util.SimanticsKeys;
import org.simantics.db.layer0.util.TransferableGraphConfiguration2;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.request.WriteInterface;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.graph.compiler.CompilationResult;
import org.simantics.graph.compiler.ExternalFileLoader;
import org.simantics.graph.compiler.GraphCompiler;
import org.simantics.graph.compiler.GraphCompilerPreferences;
import org.simantics.graph.compiler.ValidationMode;
import org.simantics.graph.db.IImportAdvisor;
import org.simantics.graph.db.TransferableGraphException;
import org.simantics.graph.db.TransferableGraphSource;
import org.simantics.graph.db.TransferableGraphs;
import org.simantics.graph.diff.Diff;
import org.simantics.graph.diff.TransferableGraphDelta1;
import org.simantics.graph.representation.Identity;
import org.simantics.graph.representation.IdentityDefinition;
import org.simantics.graph.representation.Root;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.graphfile.ontology.GraphFileResource;
import org.simantics.layer0.Layer0;
import org.simantics.ltk.ISource;
import org.simantics.ltk.Problem;
import org.simantics.modeling.internal.Activator;
import org.simantics.utils.FileUtils;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompilePGraphs {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompilePGraphs.class);

    public static void compilePGraphs(Resource r) throws IOException, DatabaseException {
        CompilePGraphs.compilePGraphs(r, null);
    }

    public static void compilePGraphs(Resource r, UserAgent userAgent) throws IOException, DatabaseException {
        CompilePGraphs.compilePGraphs(r, userAgent, (IProgressMonitor)new NullProgressMonitor());
    }

    public static void compilePGraphs(final Resource r, UserAgent userAgent, IProgressMonitor monitor) throws IOException, DatabaseException {
        final ArrayList sources = new ArrayList();
        final ArrayList<TransferableGraph1> dependencies = new ArrayList<TransferableGraph1>();
        Pair thisOntology = (Pair)Simantics.sync((ReadInterface)new UniqueRead<Pair<String, TransferableGraph1>>(){

            public Pair<String, TransferableGraph1> perform(ReadGraph graph) throws DatabaseException {
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                final Resource parent = graph.getSingleObject(r, L0.PartOf);
                DefaultCopyHandler ch = new DefaultCopyHandler(r){

                    protected TransferableGraphConfiguration2 createConfiguration(ReadGraph graph, boolean cut) throws DatabaseException {
                        HashMap<Resource, SubgraphExtent.ExtentStatus> preStatus = new HashMap<Resource, SubgraphExtent.ExtentStatus>();
                        preStatus.put(r, SubgraphExtent.ExtentStatus.EXTERNAL);
                        if (!parent.equals(graph.getRootLibrary())) {
                            preStatus.put(parent, SubgraphExtent.ExtentStatus.EXTERNAL);
                        }
                        return new TransferableGraphConfiguration2(null, Collections.emptyList(), preStatus, true, true);
                    }

                    protected TransferableGraphSource computeSource(ReadGraph graph, TransferableGraphConfiguration2 conf) throws DatabaseException {
                        return (TransferableGraphSource)graph.syncRequest((Read)new ModelTransferableGraphSourceRequest(conf){

                            protected ModelTransferableGraphSource getSource(ReadGraph graph, TransferableGraphConfiguration2 configuration, DomainProcessorState state, File otherStatementsFile, File valueFile) throws DatabaseException {
                                return new ModelTransferableGraphSource(graph, configuration, state, new File[]{otherStatementsFile, valueFile}){

                                    protected Identity getRootIdentity(DomainProcessorState state, SerialisationSupport support, Resource rootLibrary) throws DatabaseException {
                                        return new Identity(state.ids.get(support.getTransientId(rootLibrary)), (IdentityDefinition)new Root("", ""));
                                    }
                                };
                            }
                        });
                    }
                };
                String uri = graph.getURI(r);
                SimanticsClipboardImpl clipboard = new SimanticsClipboardImpl();
                ch.copyToClipboard(graph, (SimanticsClipboardBuilder)clipboard);
                for (Set object : clipboard.getContents()) {
                    TransferableGraph1 tg = (TransferableGraph1)ClipboardUtils.accept((ReadGraph)graph, (Set)object, (IHintContext.Key)SimanticsKeys.KEY_TRANSFERABLE_GRAPH);
                    if (tg == null) continue;
                    return Pair.make((Object)uri, (Object)tg);
                }
                return null;
            }
        });
        if (thisOntology == null) {
            throw new DatabaseException("Failed to dump the containing ontology of " + r + " into TransferableGraph1");
        }
        dependencies.add((TransferableGraph1)thisOntology.second);
        Bundle[] bundleArray = Activator.getContext().getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            URL tg;
            Bundle b = bundleArray[n2];
            Iterator id = b.getSymbolicName();
            String name = (String)b.getHeaders().get("Bundle-Name");
            if (name == null) {
                name = id;
            }
            if (!name.equals(thisOntology.first) && (tg = b.getEntry("/graph.tg")) != null) {
                File f = CompilePGraphs.url2file(FileLocator.resolve((URL)tg), b.getSymbolicName());
                try {
                    dependencies.add(GraphCompiler.read((File)f));
                }
                catch (Exception e) {
                    throw new IOException("Failed to read compiled transferable graph as dependency: " + f, e);
                }
            }
            ++n2;
        }
        Simantics.sync((ReadInterface)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                for (Resource file : (Collection)graph.syncRequest((Read)new ObjectsWithType(r, L0.ConsistsOf, L0.PGraph))) {
                    String src = (String)graph.getRelatedValue(file, L0.PGraph_definition, (Binding)Bindings.STRING);
                    sources.add(new StringSource(src));
                }
            }
        });
        final GraphCompilerPreferences prefs = new GraphCompilerPreferences();
        prefs.validate = true;
        prefs.validateRelationRestrictions = ValidationMode.ERROR;
        prefs.validateResourceHasType = ValidationMode.IGNORE;
        final CompilationResult result = (CompilationResult)Simantics.sync((ReadInterface)new UniqueRead<CompilationResult>(){

            public CompilationResult perform(ReadGraph graph) throws DatabaseException {
                Resource root = (Resource)graph.syncRequest((Read)new IndexRoot(r));
                String baseURI = graph.getURI(root);
                GraphFileResource GF = GraphFileResource.getInstance((ReadGraph)graph);
                ExternalFileLoader fileLoader = fileName -> {
                    try {
                        Resource file = graph.getResource(String.valueOf(baseURI) + "/" + fileName);
                        return (byte[])graph.getRelatedValue(file, graphFileResource.HasFiledata, (Binding)Bindings.BYTE_ARRAY);
                    }
                    catch (DatabaseException e) {
                        throw new IOException(e);
                    }
                };
                return GraphCompiler.compile((String)"1.1", (Collection)sources, (Collection)dependencies, (ExternalFileLoader)fileLoader, (GraphCompilerPreferences)prefs);
            }
        });
        if (!result.getErrors().isEmpty() || !result.getWarnings().isEmpty()) {
            if (userAgent != null) {
                userAgent.reportProblems(result);
                return;
            }
            StringBuilder error = new StringBuilder();
            for (Problem problem : result.getErrors()) {
                error.append(problem.getLocation() + ": " + problem.getDescription() + "\n");
            }
            for (Problem problem : result.getWarnings()) {
                error.append(problem.getLocation() + ": " + problem.getDescription() + "\n");
            }
            throw new DatabaseException(error.toString());
        }
        final Pair existing = (Pair)Simantics.sync((ReadInterface)new UniqueRead<Pair<TransferableGraph1, long[]>>(){

            public Pair<TransferableGraph1, long[]> perform(ReadGraph graph) throws DatabaseException {
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                TransferableGraph1 tg = (TransferableGraph1)graph.getPossibleRelatedValue(r, L0.SharedOntology_tg, Bindings.getBindingUnchecked(TransferableGraph1.class));
                if (tg == null) {
                    return null;
                }
                long[] tgResources = (long[])graph.getPossibleRelatedValue(r, L0.SharedOntology_tgResources, (Binding)Bindings.LONG_ARRAY);
                if (tgResources == null) {
                    return null;
                }
                return Pair.make((Object)tg, (Object)tgResources);
            }
        });
        if (existing != null) {
            Simantics.sync((WriteInterface)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    TransferableGraphDelta1 delta = new Diff((TransferableGraph1)existing.first, result.getGraph()).diff();
                    long[] resourceArray = TransferableGraphs.applyDelta((WriteGraph)graph, (long[])((long[])existing.second), (TransferableGraphDelta1)delta);
                    Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                    graph.claimLiteral(r, L0.SharedOntology_tg, (Object)result.getGraph(), Bindings.getBindingUnchecked(TransferableGraph1.class));
                    graph.claimLiteral(r, L0.SharedOntology_tgResources, L0.ResourceIdArray, (Object)resourceArray, (Binding)Bindings.LONG_ARRAY);
                    Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)("Compiled ontology " + graph.getURI(r)));
                }
            });
        } else {
            final DefaultPasteImportAdvisor advisor = new DefaultPasteImportAdvisor(r);
            try {
                DefaultPasteHandler.defaultExecute((TransferableGraph1)result.getGraph(), (Resource)r, (IImportAdvisor)advisor);
            }
            catch (TransferableGraphException e) {
                throw new DatabaseException((Throwable)e);
            }
            Simantics.sync((WriteInterface)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                    graph.claimLiteral(r, L0.SharedOntology_tg, (Object)result.getGraph(), Bindings.getBindingUnchecked(TransferableGraph1.class));
                    graph.claimLiteral(r, L0.SharedOntology_tgResources, L0.ResourceIdArray, (Object)advisor.getResourceIds(), (Binding)Bindings.LONG_ARRAY);
                    Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)("Compiled ontology " + graph.getURI(r)));
                }
            });
        }
    }

    private static File extractLib(URL libURL, String libName) throws FileNotFoundException, IOException {
        String tmpDirStr = System.getProperty("java.io.tmpdir");
        if (tmpDirStr == null) {
            throw new NullPointerException("java.io.tmpdir property is null");
        }
        File tmpDir = new File(tmpDirStr);
        File libFile = new File(tmpDir, libName);
        return FileUtils.copyResource((URL)libURL, (File)libFile, (boolean)false);
    }

    private static File url2file(URL url, String fileName) {
        if ("file".equals(url.getProtocol())) {
            try {
                File path = new File(URLDecoder.decode(url.getPath(), "UTF-8"));
                return path;
            }
            catch (UnsupportedEncodingException e) {
                org.simantics.db.common.utils.Logger.defaultLogError((Throwable)e);
            }
        } else if ("jar".equals(url.getProtocol())) {
            try {
                File libFile = CompilePGraphs.extractLib(url, fileName);
                return libFile;
            }
            catch (FileNotFoundException e) {
                org.simantics.db.common.utils.Logger.defaultLogError((Throwable)e);
            }
            catch (IOException e) {
                org.simantics.db.common.utils.Logger.defaultLogError((Throwable)e);
            }
        } else {
            LOGGER.warn("Unsupported URL protocol");
        }
        return null;
    }

    private static class StringSource
    implements ISource {
        private String src;
        private ByteArrayInputStream baos;

        public StringSource(String s) {
            this.src = s;
            this.baos = new ByteArrayInputStream(this.src.getBytes());
        }

        public int startPos() {
            return 0;
        }

        public int startLine() {
            return 0;
        }

        public InputStream open() throws IOException {
            return this.baos;
        }

        public int length() throws IOException {
            return this.src.length();
        }

        public String getName() {
            return "Source";
        }
    }

    public static interface UserAgent {
        public void reportProblems(CompilationResult var1);
    }
}

