/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.utils;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.unitParser.ParseException;
import org.simantics.sysdyn.unitParser.UnitCheckingException;
import org.simantics.sysdyn.unitParser.UnitCheckingNode;
import org.simantics.sysdyn.unitParser.UnitParser;
import org.simantics.sysdyn.unitParser.nodes.UnitResult;
import org.simantics.ui.SimanticsUI;
import org.simantics.utils.datastructures.Pair;

public class Function
implements Comparable<Function> {
    private final String name;
    private final Type type;
    private final ArrayList<Input> inputList;
    private final ArrayList<Output> outputList;
    private final String description;

    public Function(String name, ArrayList<Input> inputList, ArrayList<Output> outputList, Type type, String description) {
        this.name = new String(name);
        this.type = type;
        this.inputList = inputList != null ? inputList : new ArrayList();
        this.outputList = outputList != null ? outputList : new ArrayList();
        this.description = description != null ? new String(description) : null;
    }

    public static String inputListToString(ArrayList<Input> inputList) {
        String inputStr = null;
        for (Input p : inputList) {
            String pName;
            if (p.variableLength) {
                pName = "";
                for (String label : p.variableLengthLabels) {
                    pName = String.valueOf(pName) + label + ", ";
                }
                pName = String.valueOf(pName) + "...";
            } else {
                pName = p.name;
            }
            inputStr = inputStr == null ? new String(pName) : String.valueOf(inputStr) + ", " + pName;
        }
        return inputStr;
    }

    public ArrayList<Input> getInputList() {
        return this.inputList;
    }

    public ArrayList<Output> getOutputList() {
        return this.outputList;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public int compareTo(Function f) {
        int typeCompare = this.type.compareTo(f.getType());
        return typeCompare != 0 ? typeCompare : this.name.compareTo(f.getName());
    }

    public static ArrayList<Input> getFunctionInputs(ReadGraph graph, SysdynResource sr, Resource r) throws DatabaseException {
        Resource inputs = graph.getPossibleObject(r, sr.SysdynModelicaFunction_inputs);
        ArrayList<Input> inputParameters = new ArrayList<Input>();
        if (inputs != null) {
            for (Resource input : ListUtils.toList((ReadGraph)graph, (Resource)inputs)) {
                Input inputParameter = new Input();
                inputParameter.name = NameUtils.getSafeName((ReadGraph)graph, (Resource)input);
                inputParameter.optional = (Boolean)graph.getPossibleRelatedValue(input, sr.SysdynModelicaFunction_optional, (Binding)Bindings.BOOLEAN);
                inputParameter.unit = (String)graph.getPossibleRelatedValue(input, sr.SysdynModelicaFunction_unit, (Binding)Bindings.STRING);
                if (graph.isInstanceOf(input, sr.SysdynModelicaFunction_VariableLengthInput)) {
                    inputParameter.variableLength = true;
                    Resource shownLabels = graph.getPossibleObject(input, sr.SysdynModelicaFunction_VariableLengthInput_shownLabels);
                    inputParameter.variableLengthLabels = new ArrayList();
                    if (shownLabels != null) {
                        for (Resource label : ListUtils.toList((ReadGraph)graph, (Resource)shownLabels)) {
                            inputParameter.variableLengthLabels.add(NameUtils.getSafeName((ReadGraph)graph, (Resource)label));
                        }
                    }
                }
                inputParameters.add(inputParameter);
            }
        }
        return inputParameters;
    }

    protected static ArrayList<Output> getFunctionOutputs(ReadGraph graph, SysdynResource sr, Resource r) throws DatabaseException {
        Resource outputs = graph.getPossibleObject(r, sr.SysdynModelicaFunction_outputs);
        ArrayList<Output> outputParameters = new ArrayList<Output>(1);
        if (outputs != null) {
            for (Resource output : ListUtils.toList((ReadGraph)graph, (Resource)outputs)) {
                Output outputParameter = new Output();
                outputParameter.name = NameUtils.getSafeName((ReadGraph)graph, (Resource)output);
                outputParameter.unit = (String)graph.getPossibleRelatedValue(output, sr.SysdynModelicaFunction_unit, (Binding)Bindings.STRING);
                outputParameters.add(outputParameter);
            }
        }
        return outputParameters;
    }

    public static String getFunctionDescription(ReadGraph graph, Resource r) throws DatabaseException {
        String descriptionStr = null;
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        Resource description = graph.getPossibleObject(r, l0.HasDescription);
        if (description != null) {
            descriptionStr = (String)graph.getPossibleRelatedValue(r, l0.HasDescription, (Binding)Bindings.STRING);
        }
        return descriptionStr;
    }

    private static ArrayList<Function> getFunctionsOfType(ReadGraph graph, String functionTypeUri, Type functionType) throws DatabaseException {
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        ArrayList<Function> functions = new ArrayList<Function>();
        Resource functionLibrary = graph.getPossibleResource(functionTypeUri);
        for (Resource r : (Collection)graph.syncRequest((Read)new ObjectsWithType(functionLibrary, l0.ConsistsOf, sr.SysdynModelicaFunction))) {
            String name = NameUtils.getSafeName((ReadGraph)graph, (Resource)r);
            if (functionType.equals((Object)Type.XMILE)) {
                name = "XMILE." + name;
            }
            ArrayList<Input> inputs = Function.getFunctionInputs(graph, sr, r);
            ArrayList<Output> outputs = Function.getFunctionOutputs(graph, sr, r);
            String description = Function.getFunctionDescription(graph, r);
            functions.add(new Function(name, inputs, outputs, functionType, description));
        }
        return functions;
    }

    public static ArrayList<Function> getAllBuiltInFunctions(ReadGraph graph) throws DatabaseException {
        ArrayList<Function> functions = new ArrayList<Function>();
        functions.addAll(Function.getFunctionsOfType(graph, "http://www.simantics.org/Sysdyn-1.1/Built-in%20Functions", Type.SYSDYN));
        functions.addAll(Function.getFunctionsOfType(graph, "http://www.simantics.org/Sysdyn-1.1/Built-in%20Functions/Vensim%20Functions", Type.VENSIM));
        functions.addAll(Function.getFunctionsOfType(graph, "http://www.simantics.org/Sysdyn-1.1/Built-in%20Functions/Modelica%20Functions", Type.MODELICA));
        functions.addAll(Function.getFunctionsOfType(graph, "http://www.simantics.org/Sysdyn-1.1/Built-in%20Functions/Modelica%20Array%20Functions", Type.MODELICA_ARRAY));
        functions.addAll(Function.getFunctionsOfType(graph, "http://www.simantics.org/Sysdyn-1.1/Built-in%20Functions/Xmile%20Functions", Type.XMILE));
        return functions;
    }

    public static ArrayList<Function> getAllBuiltInFunctions() {
        ArrayList result = null;
        try {
            result = (ArrayList)SimanticsUI.getSession().syncRequest((Read)new Read<ArrayList<Function>>(){

                public ArrayList<Function> perform(ReadGraph graph) throws DatabaseException {
                    return Function.getAllBuiltInFunctions(graph);
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static ArrayList<Function> getSharedFunctions(final Resource model) {
        ArrayList functions = new ArrayList();
        if (model == null) {
            return functions;
        }
        try {
            functions = (ArrayList)SimanticsUI.getSession().syncRequest((Read)new Read<ArrayList<Function>>(){

                public ArrayList<Function> perform(ReadGraph graph) throws DatabaseException {
                    Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                    SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                    ArrayList<Function> sharedFunctions = new ArrayList<Function>();
                    Collection linkedResources = graph.getObjects(model, l0.IsLinkedTo);
                    for (Resource r : linkedResources) {
                        if (!graph.isInstanceOf(r, sr.SharedFunctionOntology)) continue;
                        Collection<Resource> userFunctionResources = Function.getFunctionsInside(graph, r);
                        for (Resource function : userFunctionResources) {
                            String fullName = NameUtils.getSafeName((ReadGraph)graph, (Resource)function);
                            Resource parent = function;
                            do {
                                parent = graph.getPossibleObject(parent, l0.PartOf);
                                fullName = String.valueOf(NameUtils.getSafeName((ReadGraph)graph, (Resource)parent)) + "." + fullName;
                            } while (!graph.isInstanceOf(parent, l0.Ontology));
                            Function sharedFunction = new Function(fullName, Function.getFunctionInputs(graph, sr, function), Function.getFunctionOutputs(graph, sr, function), Type.SHARED, Function.getFunctionDescription(graph, function));
                            sharedFunctions.add(sharedFunction);
                        }
                    }
                    return sharedFunctions;
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        return functions;
    }

    public static ArrayList<Function> getUserDefinedFunctions(final Resource model) {
        ArrayList functions = new ArrayList();
        if (model == null) {
            return functions;
        }
        try {
            functions = (ArrayList)SimanticsUI.getSession().syncRequest((Read)new Read<ArrayList<Function>>(){

                public ArrayList<Function> perform(ReadGraph graph) throws DatabaseException {
                    Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                    SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                    ArrayList<Function> userFunctions = new ArrayList<Function>();
                    Collection<Resource> userFunctionResources = Function.getFunctionsInside(graph, model);
                    for (Resource function : userFunctionResources) {
                        String fullName = NameUtils.getSafeName((ReadGraph)graph, (Resource)function);
                        Resource parent = graph.getPossibleObject(function, l0.PartOf);
                        while (!graph.isInstanceOf(parent, sr.SysdynModel)) {
                            fullName = String.valueOf(NameUtils.getSafeName((ReadGraph)graph, (Resource)parent)) + "." + fullName;
                            parent = graph.getPossibleObject(parent, l0.PartOf);
                        }
                        Function userFunction = new Function(fullName, Function.getFunctionInputs(graph, sr, function), Function.getFunctionOutputs(graph, sr, function), Type.USER_DEFINED, Function.getFunctionDescription(graph, function));
                        userFunctions.add(userFunction);
                    }
                    return userFunctions;
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        return functions;
    }

    public static Collection<Resource> getFunctionsInside(ReadGraph graph, Resource r) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
        ArrayList<Resource> functions = new ArrayList<Resource>();
        functions.addAll((Collection)graph.syncRequest((Read)new ObjectsWithType(r, l0.ConsistsOf, sr.SysdynModelicaFunction)));
        Collection functionLibraries = (Collection)graph.syncRequest((Read)new ObjectsWithType(r, l0.ConsistsOf, sr.SysdynModelicaFunctionLibrary));
        for (Resource library : functionLibraries) {
            functions.addAll(Function.getFunctionsInside(graph, library));
        }
        return functions;
    }

    public String getDescriptionHTML() {
        if (this.description == null) {
            return null;
        }
        return this.description.replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\n", "<BR>");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean areArgumentUnitsValid(ArrayList<Pair<UnitResult, String>> argumentUnits, HashMap<String, String> correspondences, ArrayList<Function> functions, boolean allowEquivalents, HashMap<String, String> units) throws UnitCheckingException {
        ArrayList<Boolean> inputMatches = new ArrayList<Boolean>();
        int i = 0;
        while (i < this.inputList.size()) {
            inputMatches.add(Boolean.FALSE);
            ++i;
        }
        i = 0;
        while (i < argumentUnits.size()) {
            if (this.inputList.size() == 0) {
                return false;
            }
            if (argumentUnits.get((int)i).second != null) {
                boolean found = false;
                int j = 0;
                while (j < this.inputList.size()) {
                    Input namedInput = this.inputList.get(j);
                    if (namedInput.name.equals(argumentUnits.get((int)i).second)) {
                        UnitResult inputUnit = namedInput.getUnitResult(units, this, functions, allowEquivalents, correspondences);
                        if (!inputUnit.equals(argumentUnits.get((int)i).first)) {
                            return false;
                        }
                        inputMatches.set(j, Boolean.TRUE);
                        found = true;
                        break;
                    }
                    ++j;
                }
                if (!found) {
                    throw new UnitCheckingException("Undefined input argument " + (String)argumentUnits.get((int)i).second + " used in function " + this.getName() + ".");
                }
            } else if (i >= this.inputList.size()) {
                Input input = this.inputList.get(this.inputList.size() - 1);
                if (!input.variableLength) return false;
                UnitResult inputUnit = input.getUnitResult(units, this, functions, allowEquivalents, correspondences);
                if (!inputUnit.equals(argumentUnits.get((int)i).first)) {
                    return false;
                }
            } else {
                UnitResult inputUnit = this.inputList.get(i).getUnitResult(units, this, functions, allowEquivalents, correspondences);
                if (inputUnit.getUnitType() == UnitResult.UnitType.SCALAR && ((UnitResult)argumentUnits.get((int)i).first).getUnitType() != UnitResult.UnitType.SCALAR) {
                    return false;
                }
                if (!inputUnit.equals(argumentUnits.get((int)i).first)) {
                    return false;
                }
                inputMatches.set(i, Boolean.TRUE);
            }
            ++i;
        }
        i = 0;
        while (i < this.inputList.size()) {
            if (!((Boolean)inputMatches.get(i)).booleanValue() && !this.inputList.get((int)i).optional) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static class Input
    extends Parameter {
        public boolean variableLength = false;
        public boolean optional = false;
        public ArrayList<String> variableLengthLabels;
    }

    public static class Output
    extends Parameter {
    }

    public static class Parameter {
        public static final String ANY = "ANY";
        public static final String TIME = "TIME";
        public String name;
        public String unit = "ANY";

        public UnitResult getUnitResult(HashMap<String, String> units, Function f, ArrayList<Function> functions, boolean allowEquivalents, HashMap<String, String> correspondences) throws UnitCheckingException {
            UnitResult result = new UnitResult(allowEquivalents);
            if (ANY.equals(this.unit)) {
                result.setUnitType(UnitResult.UnitType.ANY);
            } else if ("1".equals(this.unit)) {
                result.setUnitType(UnitResult.UnitType.SCALAR);
            } else {
                String timeUnit = units.get("time");
                String timeReplaced = this.unit.replace(TIME, timeUnit);
                String correspondencesReplaced = Parameter.replaceCorrespondences(f, timeReplaced, correspondences);
                try {
                    StringReader outputReader = new StringReader(correspondencesReplaced);
                    UnitParser outputParser = new UnitParser(outputReader);
                    UnitCheckingNode output = (UnitCheckingNode)outputParser.expr();
                    outputReader.close();
                    result.appendResult(output.getUnits(null, functions, allowEquivalents));
                }
                catch (UnitCheckingException e) {
                    e.printStackTrace();
                }
                catch (ParseException e) {
                    throw new UnitCheckingException("Cannot validate units: Syntax error in expression.");
                }
            }
            return result;
        }

        private static String replaceCorrespondences(Function f, String original, HashMap<String, String> correspondences) throws UnitCheckingException {
            int index;
            String ret = new String(original);
            while ((index = ret.indexOf(39)) >= 0) {
                String replaced = ret.substring(index, index + 2);
                try {
                    ret = ret.replace(replaced, "(" + correspondences.get(replaced) + ")");
                }
                catch (NullPointerException npe) {
                    throw new UnitCheckingException("Function " + f.getName() + " output unit could not be determined. Replacement unit " + replaced + " not found in input unit definitions.");
                }
            }
            return ret;
        }
    }

    public static enum Type {
        USER_DEFINED,
        SHARED,
        SYSDYN,
        MODELICA,
        MODELICA_ARRAY,
        VENSIM,
        XMILE;

    }
}

