package org.simantics.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.mutable.Variant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Development {

    private static final Logger LOGGER = LoggerFactory.getLogger(Development.class);
	public static TreeMap<String,Integer> histogram = new TreeMap<>();

	public static final boolean DEVELOPMENT = false;
	
	public static final String PRINT = "Development.print";

	public interface DevelopmentListener {
		
		void handle(Object event);
		
	}
	
	final static private HashMap<String, Variant> properties = new HashMap<>(); 
	
	final static private CopyOnWriteArrayList<DevelopmentListener> listeners = new CopyOnWriteArrayList<>();

	static {
		
		if(DEVELOPMENT) {
			listeners.add(new DevelopmentListener() {
	
				@Override
				public void handle(Object event) {
					if((Boolean) getProperty(PRINT, Bindings.BOOLEAN))
						LOGGER.info(event.toString());
				}
	
			});
		}

	}
	
	public static void addListener(DevelopmentListener listener) {
		listeners.add(listener);
	}
	
	public static void removeListener(DevelopmentListener listener) {
		listeners.remove(listener);
	}
	
	public static void dispatchEvent(Object event) {
		for(DevelopmentListener listener : listeners) {
			listener.handle(event);
		}
	}
	
	
	public static void setProperty(String name, Object value, Binding binding) {
		assert(name != null);
		assert(binding != null);
		try {
			binding.assertInstaceIsValid(value);
		} catch (BindingException e) {
			throw new RuntimeException(e);
		}
		properties.put(name, new Variant(binding, value));
	}

	@SuppressWarnings("unchecked")
	public static <T> T getProperty(String name, Binding binding) {
		Variant value = properties.get(name);
		if(value == null) return null;
		try {
			return (T)value.getValue(binding);
		} catch (AdaptException e) {
			throw new RuntimeException(e);
		}
	}
	
	public static boolean isTrue(String name) {
		Boolean value = getProperty(name, Bindings.BOOLEAN);
		return value != null && value;
	}
	
	public static Map<String, Variant> getProperties() {
		return properties;
	}
	
	public static void recordHistogram(Object o) {
		String key = o.toString();
		Integer i = histogram.get(key);
		histogram.put(key, i == null ? 1 : i+1);
	}
	
}
