package org.simantics.graph.matching;

import java.util.Comparator;

class Stat {
	public int p, o;

	public Stat(int p, int o) {
		this.p = p;
		this.o = o;
	}
	
	public Stat(Stat stat) {
		this.p = stat.p;
		this.o = stat.o;
	}
	
	public void map(int[] map) {
		if(p >= 0)
			p = map[p];
		if(o >= 0)
			o = map[o];
	}
	
	@Override
	public String toString() {
		return p + " " + o;
	}
	
	public String toString(String[] names) {
		return (p >= 0 ? names[p] : "?") + " " + (o >= 0 ? names[o] : "?");
	}
	
	@Override
	public int hashCode() {
		return 31*p + o;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Stat other = (Stat) obj;
		return p==other.p && o==other.o;
	}



	static final Stat[] NO_STATS = new Stat[0];
	
	static final Comparator<Stat> STAT_COMPARATOR = new Comparator<Stat>() {
		@Override
		public int compare(Stat o1, Stat o2) {
			if(o1.p < o2.p)
				return -1;
			else if(o1.p > o2.p)
				return 1;
			else if(o1.o < o2.o)
				return -1;
			else if(o1.o > o2.o)
				return 1;
			else
				return 0;
		}
	};
}