/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.fileimport;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Optional;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.RuntimeDatabaseException;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.request.WriteInterface;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.fileimport.Activator;
import org.simantics.fileimport.IGenericFileImport;
import org.simantics.layer0.Layer0;

public abstract class SimanticsResourceFileImport
implements IGenericFileImport {
    @Override
    public final Optional<String> perform(Path file) throws Exception {
        Path dropins = Activator.getDropinsFolder();
        Path parts = file.toAbsolutePath().toString().startsWith(dropins.toAbsolutePath().toString()) ? dropins.relativize(file) : file.getFileName();
        Resource parent = SimanticsResourceFileImport.resolveParent(null, parts);
        if (parent == null) {
            return Optional.empty();
        }
        Optional<Resource> imported = this.perform(parent, file);
        if (imported.isPresent()) {
            return Optional.of(this.serialize(imported.get()));
        }
        return Optional.empty();
    }

    @Override
    public void remove(String resourceId) throws Exception {
        final Optional<Resource> resource = this.deserialize(resourceId);
        resource.ifPresent(res -> {
            try {
                Simantics.sync((WriteInterface)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        RemoverUtil.remove((WriteGraph)graph, (Resource)((Resource)resource.get()));
                    }
                });
            }
            catch (Exception e) {
                throw new RuntimeDatabaseException((Throwable)e);
            }
        });
    }

    public String serialize(Resource resource) {
        return Long.toString(resource.getResourceId());
    }

    public Optional<Resource> deserialize(String serialized) throws Exception {
        final long resourceId = Long.valueOf(serialized);
        Resource resource = (Resource)Simantics.getSession().syncRequest((Read)new Read<Resource>(){

            public Resource perform(ReadGraph graph) throws DatabaseException {
                SerialisationSupport support = (SerialisationSupport)graph.getService(SerialisationSupport.class);
                Resource resource = support.getResource(resourceId);
                return resource;
            }
        });
        return Optional.ofNullable(resource);
    }

    private static Resource resolveParent(Resource parent, Path name) {
        if (name.getParent() == null) {
            return Simantics.getProjectResource();
        }
        name = name.getParent();
        final Resource newParent = parent = SimanticsResourceFileImport.resolveParent(parent, name);
        final String folderName = name.getFileName().toString();
        try {
            return (Resource)Simantics.getSession().syncRequest((Read)new UniqueRead<Resource>(){

                public Resource perform(ReadGraph graph) throws DatabaseException {
                    Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                    Collection libraries = (Collection)graph.sync((ReadInterface)new ObjectsWithType(newParent, L0.ConsistsOf, L0.Library));
                    for (Resource library : libraries) {
                        String libraryName = (String)graph.getRelatedValue2(library, L0.HasName, (Binding)Bindings.STRING);
                        if (!libraryName.equals(folderName)) continue;
                        return library;
                    }
                    return null;
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public abstract Resource defaultParentResource();
}

