/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.symbollibrary;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

import org.eclipse.swt.graphics.ImageData;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.query.DiagramRequests;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.stubs.G2DResource;
import org.simantics.g2d.diagram.DiagramClass;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.impl.Diagram;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.handler.StaticSymbol;
import org.simantics.g2d.image.DefaultImages;
import org.simantics.g2d.image.Image;
import org.simantics.scenegraph.g2d.G2DSceneGraph;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.utils.ui.gfx.ImageUtils;

/**
 * @author Hannu Niemist&ouml;
 */
public class IconRenderingUtil {

    public static BufferedImage renderBufferedImage(ReadGraph graph, Resource symbolResource, int size) throws DatabaseException {
        // Ensure these resources are available as services.
        G2DResource.getInstance(graph);
        StructuralResource2.getInstance(graph);
        DiagramResource.getInstance(graph);

        IDiagram diagram = Diagram.spawnNew(DiagramClass.DEFAULT);

        diagram.setHint(DiagramHints.KEY_ELEMENT_RASTER_TARGET_SIZE, new Point(size,size));
        ElementClass ec = 
                graph.syncRequest( DiagramRequests.getElementClass(symbolResource, diagram) );
        StaticSymbol ss = ec.getSingleItem(StaticSymbol.class);
        Image source = ss == null ? DefaultImages.UNKNOWN2.get() : ss.getImage();
        G2DSceneGraph sceneGraph = new G2DSceneGraph();
        source.init(sceneGraph);

        BufferedImage targetImage = new BufferedImage(size, size, 
                java.awt.image.BufferedImage.TYPE_INT_ARGB);
        Graphics2D g2d = (Graphics2D)targetImage.getGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g2d.setBackground(Color.WHITE);
        g2d.clearRect(0, 0, size, size);
        Rectangle2D bounds = source.getBounds();
        double maxB = Math.max(bounds.getWidth(), bounds.getHeight());
        double scale = size/maxB;
        g2d.setTransform(new AffineTransform(
                scale, 0.0, 0.0, scale, -bounds.getMinX()*scale, -bounds.getMinY()*scale
                ));
        sceneGraph.render(g2d);

        return targetImage;
    }

    public static ImageData renderIcon(ReadGraph graph, Resource symbolResource, int size) throws DatabaseException {
        try {
            BufferedImage img = renderBufferedImage(graph, symbolResource, size);
            if (img == null)
                return null;
            return ImageUtils.convertToSWT(img);
        } catch (Exception e) {
            // FIXME: this is here because rendering a symbol may crash in
            // totally unexpected ways if the symbol contains unrenderable content.
            return null;
        }
    }

}
