package org.simantics.diagram.symbolcontribution;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.function.Function3;

/**
 * @author Antti Villberg
 */
public class SCLFilter implements SymbolContributionFilter {
	
	Resource filter;
	
	public SCLFilter(Resource filter) {
		this.filter = filter;
	}

	@Override
	public boolean accept(ReadGraph graph, Resource contribution, Resource filter, Resource diagram) throws DatabaseException {
		
        DiagramResource DIA = DiagramResource.getInstance(graph);
        
        Variable ruleVariable = Variables.getVariable(graph, filter);

        Function3<Resource,Resource, Resource, Boolean> fn = ruleVariable.getPossiblePropertyValue(graph, DIA.SCLFilter_filter);
        if(fn == null) return true;

        SCLContext sclContext = SCLContext.getCurrent();
        Object oldGraph = sclContext.get("graph");
        try {
            sclContext.put("graph", graph);
            return fn.apply(contribution, filter, diagram);
        } catch (Throwable t) {
        	throw new DatabaseException(t);
        } finally {
            sclContext.put("graph", oldGraph);
        }
		
	}

}
