/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.symbolcontribution;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;

import org.simantics.diagram.symbollibrary.ISymbolGroup;
import org.simantics.diagram.symbollibrary.ISymbolItem;

/**
 * @author Hannu Niemist&ouml;
 */
public class CompositeSymbolGroup extends ModifiableSymbolGroup {

    Collection<ISymbolGroup> groups = new ArrayList<ISymbolGroup>(4);

    public CompositeSymbolGroup(Object identification, String name, String description) {
        super(identification, name, description);
    }

    public void add(ISymbolGroup group) {
        groups.add(group);
    }

    public Collection<ISymbolGroup> getGroups() {
        return groups;
    }

    @Override
    public ISymbolItem[] getItems() {
        ArrayList<ISymbolItem> items = new ArrayList<ISymbolItem>();
        for(ISymbolGroup group : groups)
            for(ISymbolItem item : group.getItems())
                items.add(new GroupProxySymbolItem(item,  this));
        Collections.sort(items, new Comparator<ISymbolItem>() {
            @Override
            public int compare(ISymbolItem o1, ISymbolItem o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return items.toArray(new ISymbolItem[items.size()]);
    }

    @Override
    public String toString() {
        return super.toString() + "[composed group count=" + groups.size() + "]";
    }

}
