/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.query;

import java.awt.Stroke;

import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.G2DUtils;
import org.simantics.diagram.connection.ConnectionVisuals;
import org.simantics.diagram.stubs.G2DResource;
import org.simantics.g2d.element.handler.EdgeVisuals.StrokeType;

/**
 * @author Tuukka Lehtonen
 */
public class ConnectionVisualsRequest extends ResourceRead<ConnectionVisuals> {

    G2DResource g2d;

    public ConnectionVisualsRequest(Resource connectionType) {
        super(connectionType);
        assert connectionType != null;
    }

    @Override
    public ConnectionVisuals perform(ReadGraph g) throws DatabaseException {
        g2d = G2DResource.getInstance(g);
        Resource structuralConnectionType = resource;

        // Load edge visual aspects
        Resource c = g.getPossibleObject(structuralConnectionType, g2d.HasColor);
        float[] color = null;
        if (c != null) {
            float[] col = g.getPossibleValue(c, Bindings.FLOAT_ARRAY);
            if (col != null && col.length >= 3) {
                color = col;
            }
        }

        StrokeType strokeType = toStrokeType(g.getPossibleObject(structuralConnectionType, g2d.HasStrokeType));
        Stroke stroke = G2DUtils.getStroke(g, g.getPossibleObject(structuralConnectionType, g2d.HasStroke));
        Double branchPointRadius = g.getPossibleRelatedValue(structuralConnectionType, g2d.HasBranchPointRadius, Bindings.DOUBLE);
        Double rounding = g.getPossibleRelatedValue(structuralConnectionType, g2d.HasRounding, Bindings.DOUBLE);
        
        return new ConnectionVisuals(color, strokeType, stroke, branchPointRadius, rounding);
    }

    StrokeType toStrokeType(Resource strokeType) {
        if (strokeType != null) {
            if (strokeType.equals(g2d.StrokeType_Scaling))
                return StrokeType.Absolute;
            if (strokeType.equals(g2d.StrokeType_Nonscaling))
                return StrokeType.Relative;
        }
        return null;
    }

}
