package org.simantics.diagram.profile;

import java.awt.Font;
import java.awt.geom.AffineTransform;

import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.datatypes.literal.Vec2d;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.diagram.G2DUtils;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.stubs.G2DResource;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.modeling.ModelingResources;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.scl.runtime.tuple.Tuple3;
import org.simantics.utils.datastructures.Pair;

/**
 * @author Antti Villberg
 */
public class SCLTextGridStyle extends TextGridStyle {

	final Resource style;
	final Font font;

	public SCLTextGridStyle(ReadGraph graph, Resource style) throws DatabaseException {
		this.style = style;
		G2DResource G2D = G2DResource.getInstance(graph);
        Resource fontR = graph.getPossibleObject(style, G2D.HasFont);
		if(fontR != null) {
			font = G2DUtils.getFont(graph, fontR);
		} else {
			font = null;
		}

	}

	@Override
	protected Font getFont() {
		if(font != null) return font;
		return super.getFont();
	}

	@Override
	public Resource getPropertyRelation(ReadGraph graph, Resource module) {
		throw new Error("Fix this");
	}

	@Override
	protected Object getIdentity(Resource entry) {
		return new Pair<Resource, Resource>(style, entry);
	}

	@Override
	protected String rowId() {
		return getNodeName();
	}

	@Override
	public MonitorTextGridResult calculateStyle(ReadGraph graph, Resource runtimeDiagram, Resource entry, Resource element, Variable configuration)
			throws DatabaseException {

		DiagramResource DIA = DiagramResource.getInstance(graph);
		ModelingResources MOD = ModelingResources.getInstance(graph);

		String variableURI = graph.getPossibleRelatedValue(runtimeDiagram, DIA.RuntimeDiagram_HasVariable, Bindings.STRING);
		Variable activeVariable = org.simantics.db.layer0.variable.Variables.getPossibleVariable(graph, variableURI);
		if (activeVariable == null)
			return null;

		Resource module = graph.getPossibleObject(element, MOD.ElementToComponent);
		if (module == null)
			return null;

		Variable moduleVariable = activeVariable.browsePossible(graph, module);
		if (moduleVariable == null)
			return null;

		Variable styleVariable = Variables.getVariable(graph, style);
		Function1<Variable,Tuple3> function = styleVariable.getPossiblePropertyValue(graph, DIA.SCLTextGridStyle_texts);
		Tuple3 result = Simantics.applySCLRead(graph, function, moduleVariable);
		
		AffineTransform transform = DiagramGraphUtil.getAffineTransform(graph, element);
		Vec2d offset = DiagramGraphUtil.getOffset(graph, element);
		boolean enabled = !DiagramGraphUtil.getProfileMonitorsHidden(graph, element);
		boolean up = DiagramGraphUtil.getProfileMonitorsUp(graph, element);
		double spacing = DiagramGraphUtil.getProfileMonitorSpacing(graph, element);

		return new MonitorTextGridResult(rowId(), (String)result.c0, (String)result.c1, (String)result.c2, enabled, up, spacing, null, null, ElementTranslation.function(element), transform, offset);

	}

	@Override
	public String getNodeName() {
		return "" + style.getResourceId();
	}

}
