/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.profile;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.primitiverequest.OrderedSet;
import org.simantics.db.common.procedure.wrapper.SetListenerToSingleSetListener;
import org.simantics.db.common.request.BinaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.SetListener;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.scenegraph.profile.Group;

/**
 * @author Tuukka Lehtonen
 */
public abstract class DiagramElementGroup implements Group {

    protected DiagramResource DIA;

    public DiagramElementGroup(ReadGraph graph) {
        this.DIA = DiagramResource.getInstance(graph);
    }

    @Override
    public void trackItems(RequestProcessor processor, final Resource runtimeDiagram, final SetListener<Resource> listener) {
        processor.asyncRequest(new BinaryRead<Class<?>, Resource, Collection<Resource>>(getClass(), runtimeDiagram) {

            @Override
            public Set<Resource> perform(ReadGraph graph) throws DatabaseException {
                HashSet<Resource> result = new HashSet<Resource>();

                Resource realDiagram = graph.getPossibleObject(parameter2, DIA.RuntimeDiagram_HasConfiguration);
                if (realDiagram == null)
                    return result;

                Collection<Resource> elements = graph.syncRequest(new OrderedSet(realDiagram));
                for (Resource element : elements) {
                    if (test(graph, element)) {
                        result.add(element);
                    }
                }

                return result;
            }

        }, new SetListenerToSingleSetListener<Resource>(listener));
    }

    protected abstract boolean test(ReadGraph graph, Resource element) throws DatabaseException;

}
