/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.adapter;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementClass;

public class NodeClassRequest extends BaseRequest2<Resource, ElementClass> {

    private final IDiagram diagram;
    private final boolean exceptionOnAdaptionFailure;

    public NodeClassRequest(ICanvasContext canvas, IDiagram diagram, Resource resource) {
        this(canvas, diagram, resource, false);
    }

    public NodeClassRequest(ICanvasContext canvas, IDiagram diagram, Resource resource, boolean exceptionOnAdaptionFailure) {
        super(canvas, resource);
        this.diagram = diagram;
        this.exceptionOnAdaptionFailure = exceptionOnAdaptionFailure;
    }

    @Override
    public void perform(AsyncReadGraph graph, final AsyncProcedure<ElementClass> procedure) {

//        System.out.println("NodeClassRequest " + data.getResourceId());
//        graph.asyncRequest(new SafeName(data), new Procedure<String>() {
//            @Override
//            public void exception(Throwable t) {
//            }
//            @Override
//            public void execute(String result) {
//                System.out.println("NodeClassRequest "  + result);
//                debug = result;
//            }
//        });

        graph.forAdapted(data, ElementFactory.class, new AsyncProcedure<ElementFactory>() {

            @Override
            public void exception(AsyncReadGraph graph, Throwable throwable) {
                if (exceptionOnAdaptionFailure)
                    procedure.exception(graph, throwable);
                else
                    procedure.execute(graph, null);
            }

            @Override
            public void execute(AsyncReadGraph graph, final ElementFactory factory) {

//                System.out.println("NodeClassRequest factory " + data.getResourceId() + " = " + factory.getClass().getName());
//                graph.asyncRequest(new SafeName(data), new Procedure<String>() {
//                    @Override
//                    public void exception(Throwable t) {
//                    }
//                    @Override
//                    public void execute(String result) {
//                        System.out.println("NodeClassRequest "  + result + " " + factory.getClass().getName());
//                        debug = result;
//                    }
//                });

                if (factory == null) {
                    // Should never happen since we are using forAdapted
                    System.out.println("No factory in NodeClassRequest! " + this);
                    procedure.execute(graph, null);
                    return;
                }

                factory.create(graph, canvas, diagram, data, new AsyncProcedure<ElementClass>() {

                    @Override
                    public void exception(AsyncReadGraph graph, Throwable throwable) {
                        procedure.exception(graph, throwable);
                    }

                    @Override
                    public void execute(AsyncReadGraph graph, ElementClass ec) {
//                        System.out.println("Produced element class " + ec);
                        procedure.execute(graph, ec);
                    }

                });

            }

        });

    }

}
