/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.adapter;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.common.procedure.adapter.ListenerSupport;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.diagram.content.EdgeResource;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.synchronization.ErrorHandler;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.impl.Element;

/**
 * @author Antti Villberg
 */
public class EdgeRequest extends BaseRequest2<EdgeResource, IElement> {

    final ErrorHandler errorHandler;
    final ListenerSupport listenerSupport;
    final IDiagram diagram;
    final ConnectionSegmentAdapter adapter;

    public EdgeRequest(ICanvasContext canvas, ErrorHandler errorHandler, ListenerSupport listenerSupport, IDiagram diagram, ConnectionSegmentAdapter adapter, EdgeResource resource) {
        super(canvas, resource);

        assert(adapter != null);

        this.errorHandler = errorHandler;
        this.listenerSupport = listenerSupport;
        this.diagram = diagram;
        this.adapter = adapter;
    }

    @Override
    public void perform(AsyncReadGraph graph, final AsyncProcedure<IElement> procedure) {
//        final ITask task = ThreadLogger.getInstance().begin("NodeRequest2 " + data.getResourceId());
        final DiagramResource dr = graph.getService(DiagramResource.class);

        graph.forHasStatement(data.first(), new AsyncProcedure<Boolean>() {

            @Override
            public void exception(AsyncReadGraph graph, Throwable throwable) {
                procedure.exception(graph, throwable);
            }

            @Override
            public void execute(AsyncReadGraph graph, Boolean result) {
                if (!result) {
                    procedure.execute(graph, null);
                    return;
                }

                graph.asyncRequest(new ConnectionInfoRequest(dr, data), new TransientCacheAsyncListener<ConnectionInfo>() {

                    @Override
                    public void exception(AsyncReadGraph graph, Throwable throwable) {
                        errorHandler.error("ConnectionInfoRequest failure", throwable);
                    }

                    @Override
                    public void execute(AsyncReadGraph graph, final ConnectionInfo info) {
                        adapter.getClass(graph, data, info, listenerSupport, canvas, diagram, new AsyncProcedure<ElementClass>() {
                            @Override
                            public void exception(AsyncReadGraph graph, Throwable throwable) {
                                errorHandler.error("ConnectionSegmentAdapter(" + adapter + ").getClass failure", throwable);
                            }

                            @Override
                            public void execute(AsyncReadGraph graph, final ElementClass clazz) {
                                if (clazz == null) {
                                    procedure.execute(graph, null);
                                    return;
                                }

//                                final ITask task = ThreadLogger.getInstance().begin("SpawnEdge");
                                graph.asyncRequest(new SpawnEdgeRequest(canvas, clazz, data), new AsyncProcedure<IElement>() {
                                    @Override
                                    public void exception(AsyncReadGraph graph, Throwable throwable) {
                                        errorHandler.error("SpawnEdgeRequest failure", throwable);
                                    }

                                    @Override
                                    public void execute(AsyncReadGraph graph, IElement element) {
//                                        task.finish();
                                        // Tell the procedure to use this element
                                        procedure.execute(graph, element);

                                        // Create a separate element for
                                        // loading the edge which
                                        // will then be updated into
                                        // element by the listener in
                                        // the connection segment adapter.
                                        IElement loadingElement = Element.spawnNew(clazz);
                                        loadingElement.setHint(ElementHints.KEY_OBJECT, data);

                                        adapter.load(graph, data, info, listenerSupport, canvas, diagram, loadingElement);
                                    }
                                });
                            }
                        });
                    }
                });
            }
        });
    }

}
