/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.adapter;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;

import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.profile.ProfileKeys;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.layer0.Layer0;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.profile.DataNodeMap;
import org.simantics.scenegraph.profile.EvaluationContext;
import org.simantics.scenegraph.profile.Group;
import org.simantics.scenegraph.profile.Style;
import org.simantics.scenegraph.profile.common.ObserverGroupListener;
import org.simantics.scenegraph.profile.common.ProfileVariables;

public class ConstantStyle implements Style {

    final String name;
    final Map<String, Object> values = new HashMap<String, Object>();
    ObserverGroupListener listener = null;

    public ConstantStyle(ReadGraph graph, Resource style) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance(graph);
        DiagramResource DIA = DiagramResource.getInstance(graph);
        this.name = graph.getPossibleRelatedValue(style, L0.HasName, Bindings.STRING);
        String[] values = graph.getPossibleRelatedValue(style, DIA.HasValues, Bindings.getBindingUnchecked(String[].class));
        for(int i=0;i<values.length;i+=2) {
            String key  = values[i];
            Object value = haxx(key, values[i+1]);
            this.values.put(key, value);
        }
    }

    private Object haxx(String key, Object value) {
        if("alpha".equals(key)) {
            return AlphaComposite.getInstance(AlphaComposite. SRC_OVER, Float.parseFloat((String)value));
        } else if("color".equals(key)) {
            return new Color(Integer.parseInt(value.toString(), 16));
        } else {
            return value;
        }
    }

    @Override
    public void deactivate(Resource diagram, Resource entry, Group group,
    		EvaluationContext observer) {
        if (listener != null && !listener.isDisposed()) {
            listener.dispose();
            values.clear();
            observer.update();
        }
    }

    @Override
    public void activate(RequestProcessor backend, Resource diagram, Resource entry, Group group, final EvaluationContext observer) {

        if (listener != null && !listener.isDisposed())
            return;

        listener = new ObserverGroupListener(this, group, observer);

        group.trackItems(backend, diagram, listener);

    }

    @Override
    public void apply(Resource entry, Group group, final EvaluationContext evaluationContext) {

//        throw new UnsupportedOperationException();
        
//        IDiagram diagram = evaluationContext.getConstant(ProfileKeys.DIAGRAM);
        ICanvasContext context = evaluationContext.getConstant(ProfileKeys.CANVAS);
        
        assert context.getThreadAccess().currentThreadAccess();

        if(listener == null) {
            System.out.println("ConstantStyle " + this + " was not active in apply!");
            return;
        }

        final DataNodeMap map = evaluationContext.getConstant(ProfileKeys.NODE_MAP);
        
//        DataElementMap map = diagram.getDiagramClass().getSingleItem(DataElementMap.class);

        for(Map.Entry<String, Object> value : values.entrySet()) {

            for(Object item : listener.getItems()) {

                final INode node = map.getNode(item);
                
//                final IElement element = map.getElement(diagram, item);
                if(node == null) {
                    //observer.exception(new NullPointerException("ConstantStyle.apply: no element for " + item));
                    evaluationContext.update();
                    return;
                }

                ProfileVariables.claimNodeProperty(node, value.getKey(), value.getValue(), evaluationContext);
                
////                System.out.println("apply[" + element + "]: " + value.getKey() + " => " + value.getValue());
//                Variables.set(node, value.getKey(), value.getValue(), evaluationContext);
//
//                PropertySetter setter = element.getElementClass().getAtMostOneItemOfClass(PropertySetter.class);
//                if(setter != null)
//                    setter.syncPropertiesToNode(element);
                
            }
        }

    }

    @Override
    public String toString() {
        return name;
    }

}
