package org.simantics.db.procore.ui.internal;

import java.io.File;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.InternalException;
import org.simantics.db.server.DatabaseCorruptedException;
import org.simantics.db.server.DatabaseLastExitException;
import org.simantics.db.server.DatabaseProtocolException;
import org.simantics.db.server.DatabaseStartException;
import org.simantics.db.server.DatabaseVersionException;
import org.simantics.db.server.GuardFileVersionException;
import org.simantics.db.server.ProCoreException;

public class UI {
    public static boolean delete(Shell shell, File folder) {
        return HandlerUtil.delete(shell, folder, "Database Delete", null);
    }
    public static boolean purge(Shell shell, File folder) {
        return HandlerUtil.purge(shell, folder, "Database Purge", null);
    }
    public static boolean handleStart(Shell shell, InternalException e) throws ProCoreException {
        if (!(e instanceof ProCoreException))
            return false; // Can not fix this exception.
        ProCoreException pce = (ProCoreException)e;
        Handler handler = getStart(pce);
        assert(null != handler);
        return handler.start(shell, pce);
    }
    public static Display getDisplay() {
        Display d = Display.getCurrent();
        if (d == null)
            d = Display.getDefault();
        return d;
    }
    static Map<Long, Handler> startHandlers = new HashMap<Long, Handler>();
    static {
        startHandlers.put(GuardFileVersionException.getHandlerId(), new GuardFileVersionHandler());
        startHandlers.put(DatabaseCorruptedException.getHandlerId(), new DatabaseCorruptedHandler());
        startHandlers.put(DatabaseStartException.getHandlerId(), new DatabaseStartHandler());
        startHandlers.put(DatabaseVersionException.getHandlerId(), new DatabaseVersionHandler());
        startHandlers.put(DatabaseLastExitException.getHandlerId(), new DatabaseLastExitHandler());
        startHandlers.put(DatabaseProtocolException.getHandlerId(), new DatabaseProtocolHandler());
    }
    private static <E extends ProCoreException> long getId(E pe) {
        long id = 0;
        try {
            Method m = pe.getClass().getMethod("getHandlerId");
            Object value = m.invoke(null);
            id = (long)value;
        } catch (RuntimeException e) {
            Logger.defaultLogError(e);
        } catch (Exception e) {
            Logger.defaultLogError(e);
        }
        return id;
    }
    private static <E extends ProCoreException> Handler getStart(E e) {
       Handler h = startHandlers.get(getId(e));
       if (null == h)
           return new DefaultHandler();
       else
           return h;
    }
}
