package org.simantics.db.procore.ui;

import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.simantics.db.DatabaseUserAgent;
import org.simantics.db.exception.InternalException;
import org.simantics.db.procore.ProCoreDriver;

public final class ProCoreUserAgent implements DatabaseUserAgent {
    private static Shell getShell() {
	Shell shell = null;
	Display d = getDisplay();
	if (d == null)
	    return null;
	shell = d.getActiveShell();
	if (null == shell) {
	    Shell[] shells = d.getShells();
	    if (null != shells && shells.length > 0)
		shell = shells[0];
	}
	return shell;
    }
    private static Display getDisplay() {
	Display d = Display.getCurrent();
	if (d == null)
	    d = Display.getDefault();
	return d;
    }
        @Override
	public boolean handleStart(InternalException exception) {
	    Shell shell = getShell();
	    if (null == shell)
		return false; // no can do
	    try {
		return Auxiliary.handleStart(shell, exception);
	    } catch (InternalException e) {
		return false; // no could do
	    }
	}

        @Override
	public String getId() {
	    return ProCoreDriver.ProCoreDriverName;
	}
}
