package org.simantics.db.procore.ui;

import java.io.File;

import org.eclipse.swt.widgets.Shell;
import org.simantics.db.exception.InternalException;
import org.simantics.db.procore.ui.internal.UI;

public class Auxiliary {
    /**
     * @param shell for the user interface.
     * @param exception thrown from server.
     * @return true if server can be started.
     */
    public static boolean beforeStart(Shell shell, File folder) throws InternalException {
        boolean skipPurge = "true".equals(System.getProperty("org.simantics.db.procore.ui.skipPurge"));
        if (skipPurge)
            return true;
        return UI.purge(shell, folder);
    }
    /**
     * @param shell for the user interface.
     * @param exception thrown from server start.
     * @return true if problem with server start was successfully fixed.
     */
    public static boolean handleStart(Shell shell, InternalException exception) throws InternalException {
        return UI.handleStart(shell, exception);
    }
    /**
     * @param shell for the user interface.
     * @param folder of the database.
     * @return true if deletion was successful.
     */
    public static boolean delete(Shell shell, File folder) {
        return UI.delete(shell, folder);
    }
    /**
     * @param shell for the user interface.
     * @param folder of the database.
     * @return true if purge was successful.
     */
    public static boolean purge(Shell shell, File folder) {
        return UI.purge(shell, folder);
    }
}
