/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.charts.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.charts.query.AddChartItem;
import org.simantics.charts.query.ChartAndSubscriptionItemData;
import org.simantics.charts.query.ChartItemDescriptor;
import org.simantics.charts.query.NextChartItemIndexQuery;
import org.simantics.charts.ui.ChartAndSubscriptionItemDialog;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.type.BooleanType;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableReference;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.request.WriteInterface;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.subscription.NewSubscription;
import org.simantics.modeling.subscription.NewSubscriptionItem;
import org.simantics.modeling.subscription.SubscriptionsQuery;
import org.simantics.trend.configuration.TrendItem;
import org.simantics.utils.ui.dialogs.ShowError;

public class AddVariableToChartAction
implements Runnable {
    Resource chart;
    Resource subscription;
    Resource model;
    String chartName;
    String subscriptionName;
    SubscriptionsQuery.SubscriptionsResult subscriptions;
    List<VariableReference> refs;
    List<String> variableReferences;

    public AddVariableToChartAction(Resource chart, Resource subscription, List<VariableReference> refs) {
        this.refs = refs;
        this.chart = chart;
        this.subscription = subscription;
    }

    public AddVariableToChartAction init() throws DatabaseException {
        Simantics.getSession().sync((ReadInterface)new ReadRequest(){

            public void run(ReadGraph g) throws DatabaseException {
                AddVariableToChartAction.this.init(g);
            }
        });
        return this;
    }

    public AddVariableToChartAction init(ReadGraph g) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        if (this.chart != null) {
            this.chartName = (String)g.getPossibleRelatedValue(this.chart, L0.HasName, (Binding)Bindings.STRING);
            this.model = (Resource)g.syncRequest((Read)new PossibleModel(this.chart));
        } else {
            this.model = (Resource)g.syncRequest((Read)new PossibleModel(this.subscription));
        }
        if (this.model == null) {
            throw new DatabaseException("Model was not found");
        }
        Variable configuration = Variables.getConfigurationContext((ReadGraph)g, (Resource)this.model);
        this.subscriptions = (SubscriptionsQuery.SubscriptionsResult)g.sync((ReadInterface)new SubscriptionsQuery(this.model));
        if (this.subscription != null) {
            this.subscriptionName = (String)g.getPossibleRelatedValue(this.subscription, L0.HasLabel, (Binding)Bindings.STRING);
        }
        this.variableReferences = new ArrayList<String>();
        for (VariableReference var : this.refs) {
            if (var.label != null) continue;
            this.variableReferences.add(var.getVariableId().toPossibleString(g, configuration));
        }
        return this;
    }

    public void runInSwt() {
        Display display = Display.getCurrent();
        Shell shell = display.getActiveShell();
        Simantics.getSession().markUndoPoint();
        int i = 0;
        while (i < this.refs.size()) {
            VariableReference var = this.refs.get(i);
            String varStrRef = this.variableReferences.get(i);
            try {
                ChartAndSubscriptionItemData data = new ChartAndSubscriptionItemData();
                data.index = this.chart != null ? (Integer)Simantics.sync((ReadInterface)new NextChartItemIndexQuery(this.chart)) : -1;
                data.mutableCollectionSettings = true;
                data.chartName = this.chartName;
                data.hasSubscriptionItem = true;
                data.subscriptions = this.subscriptions.toNames();
                data.subscription = this.subscriptionName;
                data.binaryMode = var.getDatatype() instanceof BooleanType;
                data.variableReference = varStrRef;
                ChartAndSubscriptionItemDialog d = new ChartAndSubscriptionItemDialog(shell, data, this.chart != null);
                if (d.open() == 0) {
                    Resource subscription;
                    NewSubscription ns;
                    int j = this.subscriptions.names.indexOf(data.subscription);
                    if (j < 0) {
                        ns = new NewSubscription(this.model, data.subscription);
                        Simantics.getSession().sync((WriteInterface)ns);
                        subscription = ns.subscription;
                    } else {
                        subscription = (Resource)this.subscriptions.resources.get(j);
                    }
                    if (subscription != null) {
                        ns = new NewSubscriptionItem(subscription, data.interval, data.deadband, data.gain, data.bias, data.unit, data.label, var.getVariableId(), var.getDatatype());
                        Simantics.getSession().sync((WriteInterface)ns);
                        if (ns.subscriptionItem != null && this.chart != null) {
                            ChartItemDescriptor cid = new ChartItemDescriptor();
                            cid.drawMode = data.drawmode;
                            cid.renderer = var.getDatatype() instanceof BooleanType ? TrendItem.Renderer.Binary : TrendItem.Renderer.Analog;
                            cid.scale = data.scale;
                            cid.min = data.min;
                            cid.max = data.max;
                            cid.subscriptionItem = ns.subscriptionItem;
                            cid.color = data.color;
                            AddChartItem ci = new AddChartItem(this.chart, Collections.singletonList(cid));
                            Simantics.getSession().sync((WriteInterface)ci);
                        }
                    }
                }
            }
            catch (DatabaseException e) {
                ShowError.showError((String)((Object)((Object)e)).getClass().getName(), (String)e.getLocalizedMessage(), (Throwable)e);
            }
            ++i;
        }
    }

    @Override
    public void run() {
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (display.getThread() == Thread.currentThread()) {
            this.runInSwt();
        } else {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    AddVariableToChartAction.this.runInSwt();
                }
            });
        }
    }
}

