/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.charts.internal;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Optional;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;

public class JsonUtils {
    public static Optional<Variable> tryParseJsonPropertyVariable(RequestProcessor processor, final String json) throws DatabaseException {
        return (Optional)processor.syncRequest((Read)new UniqueRead<Optional<Variable>>(){

            public Optional<Variable> perform(ReadGraph graph) throws DatabaseException {
                return JsonUtils.tryParseJsonPropertyVariable(graph, json);
            }
        });
    }

    public static Optional<Variable> tryParseJsonPropertyVariable(ReadGraph graph, String json) throws DatabaseException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (JsonParser jp = new JsonFactory().createParser(json);){
                return JsonUtils.readPossibleVariable(graph, jp);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public static Optional<Variable> readPossibleVariable(ReadGraph graph, JsonParser jp) throws IOException, DatabaseException {
        Optional<String> uri = JsonUtils.readPossibleVariableUri(jp);
        return uri.isPresent() ? Optional.ofNullable(Variables.getPossibleVariable((ReadGraph)graph, (String)uri.get())) : Optional.empty();
    }

    public static Optional<String> readPossibleVariableUri(JsonParser jp) throws IOException {
        if (jp.nextToken() != JsonToken.START_OBJECT) {
            throw new IOException("Expected data to start with an Object");
        }
        String uri = null;
        String type = null;
        String defaultPropertyUri = null;
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String fieldName = jp.getCurrentName();
            jp.nextToken();
            if (fieldName.equals("uri")) {
                uri = jp.getValueAsString();
                continue;
            }
            if (fieldName.equals("type")) {
                type = jp.getValueAsString();
                continue;
            }
            if (!fieldName.equals("defaultPropertyUri")) continue;
            defaultPropertyUri = jp.getValueAsString();
        }
        return Optional.ofNullable("Variable".equals(type) ? (defaultPropertyUri != null ? defaultPropertyUri : uri) : null);
    }
}

