/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.graph.impl;

import org.simantics.browsing.ui.common.ErrorLogger;
import org.simantics.browsing.ui.content.Labeler;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.primitiverequest.PossibleAdapter;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.StringModifier;
import org.simantics.db.request.AsyncRead;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;

public class L0StringModifier
implements Labeler.Modifier {
    private final RequestProcessor processor;
    private final Resource resource;

    public L0StringModifier(RequestProcessor processor, Resource resource) {
        this.processor = processor;
        this.resource = resource;
    }

    public String getValue() {
        try {
            return (String)this.processor.syncRequest((AsyncRead)new PossibleAdapter(this.resource, String.class));
        }
        catch (DatabaseException e) {
            ErrorLogger.defaultLogError((Throwable)e);
            return null;
        }
    }

    public String isValid(final String label) {
        try {
            return (String)this.processor.syncRequest((Read)new Read<String>(){

                public String perform(ReadGraph graph) throws DatabaseException {
                    StringModifier modifier = (StringModifier)graph.adapt(L0StringModifier.this.resource, StringModifier.class);
                    return modifier.isValid((Object)label);
                }
            });
        }
        catch (DatabaseException e) {
            ErrorLogger.defaultLogError((Throwable)e);
            return e.getMessage();
        }
    }

    public void modify(final String label) {
        try {
            this.processor.syncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    StringModifier modifier = (StringModifier)graph.adapt(L0StringModifier.this.resource, StringModifier.class);
                    modifier.modify(graph, (Object)label);
                }
            });
        }
        catch (DatabaseException e) {
            ErrorLogger.defaultLogError((Throwable)e);
        }
    }
}

