/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.reflection.emit;

import com.strobel.core.VerifyArgument;
import com.strobel.reflection.ConstructorList;
import com.strobel.reflection.FieldList;
import com.strobel.reflection.MethodBase;
import com.strobel.reflection.MethodList;
import com.strobel.reflection.Type;
import com.strobel.reflection.TypeBindings;
import com.strobel.reflection.TypeList;
import com.strobel.reflection.TypeVisitor;
import com.strobel.reflection.emit.Error;
import com.strobel.reflection.emit.GenericParameterBuilder;
import com.strobel.reflection.emit.TypeBuilder;
import java.util.ArrayList;
import java.util.Iterator;

final class TypeBuilderInstantiation
extends Type {
    private final TypeBuilder<?> _definition;
    private final TypeBindings _typeBindings;
    private Type<?> _baseType;

    private TypeBuilderInstantiation(TypeBuilder<?> definition, TypeBindings typeBindings) {
        this._definition = (TypeBuilder)VerifyArgument.notNull(definition, (String)"definition");
        this._typeBindings = (TypeBindings)VerifyArgument.notNull((Object)typeBindings, (String)"typeBindings");
    }

    static Type makeGenericType(TypeBuilder<?> type, TypeList typeArguments) {
        VerifyArgument.notNull(type, (String)"type");
        VerifyArgument.notNull((Object)((Object)typeArguments), (String)"typeArguments");
        if (!type.isGenericTypeDefinition()) {
            throw Error.genericTypeDefinitionRequired();
        }
        return new TypeBuilderInstantiation(type, TypeBindings.create(type.getGenericTypeParameters(), typeArguments));
    }

    private Type<?> substitute(TypeList substitutes) {
        TypeList typeArguments = this.getTypeArguments();
        Type[] substituteArguments = new Type[typeArguments.size()];
        int n = substituteArguments.length;
        for (int i = 0; i < n; ++i) {
            Type t = (Type)typeArguments.get(i);
            substituteArguments[i] = t instanceof TypeBuilderInstantiation ? ((TypeBuilderInstantiation)t).substitute(substitutes) : (t instanceof GenericParameterBuilder ? (Type)substitutes.get(t.getGenericParameterPosition()) : t);
        }
        return this.getGenericTypeDefinition().makeGenericType(substituteArguments);
    }

    @Override
    public Type getDeclaringType() {
        return this._definition;
    }

    @Override
    public boolean isGenericType() {
        return true;
    }

    public Type getBaseType() {
        if (this._baseType != null) {
            return this._baseType;
        }
        Type<?> definitionBase = this._definition.getBaseType();
        if (definitionBase == null) {
            return null;
        }
        this._baseType = definitionBase instanceof TypeBuilderInstantiation ? ((TypeBuilderInstantiation)definitionBase).substitute(this.getTypeArguments()) : definitionBase;
        return this._baseType;
    }

    @Override
    protected TypeList getExplicitInterfaces() {
        TypeList definitionInterfaces = this._definition.getExplicitInterfaces();
        ArrayList interfaces = new ArrayList();
        Iterator iterator = definitionInterfaces.iterator();
        while (iterator.hasNext()) {
            Type interfaceType = (Type)iterator.next();
            interfaces.add(TypeBuilderInstantiation.substitute(interfaceType, this._typeBindings));
        }
        return Type.list(interfaces);
    }

    public Class<?> getErasedClass() {
        return this._definition.getErasedClass();
    }

    @Override
    public MethodBase getDeclaringMethod() {
        return this._definition.getDeclaringMethod();
    }

    @Override
    protected TypeBindings getTypeBindings() {
        return this._typeBindings;
    }

    @Override
    public Type getGenericTypeDefinition() {
        return this._definition;
    }

    @Override
    protected String getClassSimpleName() {
        return this._definition.getClassSimpleName();
    }

    @Override
    protected String getClassFullName() {
        return this._definition.getClassFullName();
    }

    @Override
    protected ConstructorList getDeclaredConstructors() {
        throw Error.typeHasNotBeenCreated();
    }

    @Override
    protected MethodList getDeclaredMethods() {
        throw Error.typeHasNotBeenCreated();
    }

    @Override
    protected FieldList getDeclaredFields() {
        throw Error.typeHasNotBeenCreated();
    }

    @Override
    protected TypeList getDeclaredTypes() {
        throw Error.typeHasNotBeenCreated();
    }

    @Override
    public Type getReflectedType() {
        return this._definition.getReflectedType();
    }

    @Override
    public int getModifiers() {
        return this._definition.getModifiers();
    }

    public Object accept(TypeVisitor visitor, Object parameter) {
        return visitor.visitClassType(this, parameter);
    }
}

