/*
 * Copyright (c) 2017 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.set.immutable.primitive;

import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.set.primitive.ImmutableShortSet;
import org.eclipse.collections.api.set.primitive.ShortSet;
import org.eclipse.collections.impl.set.mutable.primitive.ShortHashSet;
import org.eclipse.collections.impl.set.primitive.AbstractShortSet;

/**
 * This file was automatically generated from template file abstractImmutablePrimitiveSet.stg.
 *
 * @since 6.0.
 */
public abstract class AbstractImmutableShortSet extends AbstractShortSet implements ImmutableShortSet
{
    public ImmutableShortSet newWith(short element)
    {
        return ShortHashSet.newSet(this).with(element).toImmutable();
    }

    public ImmutableShortSet newWithout(short element)
    {
        return ShortHashSet.newSet(this).without(element).toImmutable();
    }

    public ImmutableShortSet newWithAll(ShortIterable elements)
    {
        return ShortHashSet.newSet(this).withAll(elements).toImmutable();
    }

    public ImmutableShortSet newWithoutAll(ShortIterable elements)
    {
        return ShortHashSet.newSet(this).withoutAll(elements).toImmutable();
    }

    public ShortSet freeze()
    {
        return this;
    }

    public ImmutableShortSet toImmutable()
    {
        return this;
    }
}
