/*
 * Copyright (c) 2017 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;

import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.LazyFloatIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableFloatBag;
import org.eclipse.collections.api.block.function.primitive.FloatToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.FloatPredicate;
import org.eclipse.collections.api.block.predicate.primitive.ObjectFloatPredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.primitive.FloatProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectFloatProcedure;
import org.eclipse.collections.api.map.primitive.ObjectFloatMap;
import org.eclipse.collections.api.collection.ImmutableCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableFloatCollection;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.iterator.FloatIterator;
import org.eclipse.collections.api.list.primitive.MutableFloatList;
import org.eclipse.collections.api.map.primitive.ImmutableObjectFloatMap;
import org.eclipse.collections.api.map.primitive.MutableObjectFloatMap;
import org.eclipse.collections.api.set.primitive.MutableFloatSet;
import org.eclipse.collections.api.tuple.primitive.ObjectFloatPair;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableFloatCollection;
import org.eclipse.collections.impl.iterator.UnmodifiableFloatIterator;
import org.eclipse.collections.impl.map.mutable.primitive.ObjectFloatHashMap;
import org.eclipse.collections.impl.set.mutable.UnmodifiableMutableSet;

/**
 * ImmutableObjectFloatHashMap is the non-modifiable equivalent of {@link ObjectFloatHashMap}.
 * This file was automatically generated from template file immutableObjectPrimitiveHashMap.stg.
 *
 * @since 4.0.
 */
final class ImmutableObjectFloatHashMap<K> extends AbstractImmutableObjectFloatMap<K> implements Serializable
{
    private static final long serialVersionUID = 1L;
    private final MutableObjectFloatMap<K> delegate;

    ImmutableObjectFloatHashMap(ObjectFloatMap<? extends K> delegate)
    {
        this.delegate = new ObjectFloatHashMap<K>(delegate);
    }

    public FloatIterator floatIterator()
    {
        return new UnmodifiableFloatIterator(this.delegate.floatIterator());
    }

    public void forEach(FloatProcedure procedure)
    {
        this.each(procedure);
    }

    /**
     * @since 7.0.
     */
    public void each(FloatProcedure procedure)
    {
        this.delegate.forEach(procedure);
    }

    public int count(FloatPredicate predicate)
    {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(FloatPredicate predicate)
    {
        return this.delegate.anySatisfy(predicate);
    }

    public boolean allSatisfy(FloatPredicate predicate)
    {
        return this.delegate.allSatisfy(predicate);
    }

    public boolean noneSatisfy(FloatPredicate predicate)
    {
        return this.delegate.noneSatisfy(predicate);
    }

    public ImmutableFloatCollection select(FloatPredicate predicate)
    {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableFloatCollection reject(FloatPredicate predicate)
    {
        return this.delegate.reject(predicate).toImmutable();
    }

    public float detectIfNone(FloatPredicate predicate, float ifNone)
    {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function)
    {
        return this.delegate.injectInto(injectedValue, function);
    }

    public <V> ImmutableCollection<V> collect(FloatToObjectFunction<? extends V> function)
    {
        return this.delegate.collect(function).toImmutable();
    }

    public double sum()
    {
        return this.delegate.sum();
    }

    public float max()
    {
        return this.delegate.max();
    }

    public float maxIfEmpty(float defaultValue)
    {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    public float min()
    {
        return this.delegate.min();
    }

    public float minIfEmpty(float defaultValue)
    {
        return this.delegate.minIfEmpty(defaultValue);
    }

    public double average()
    {
        return this.delegate.average();
    }

    public double median()
    {
        return this.delegate.median();
    }

    public float[] toSortedArray()
    {
        return this.delegate.toSortedArray();
    }

    public MutableFloatList toSortedList()
    {
        return this.delegate.toSortedList();
    }

    public float[] toArray()
    {
        return this.delegate.toArray();
    }

    public boolean contains(float value)
    {
        return this.delegate.contains(value);
    }

    public boolean containsAll(float... source)
    {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(FloatIterable source)
    {
        return this.delegate.containsAll(source);
    }

    public MutableFloatList toList()
    {
        return this.delegate.toList();
    }

    public MutableFloatSet toSet()
    {
        return this.delegate.toSet();
    }

    public MutableFloatBag toBag()
    {
        return this.delegate.toBag();
    }

    public LazyFloatIterable asLazy()
    {
        return this.delegate.asLazy();
    }

    public ImmutableObjectFloatMap<K> newWithKeyValue(K key, float value)
    {
        ObjectFloatHashMap<K> map = ObjectFloatHashMap.newMap();
        map.putAll(this);
        map.put(key, value);
        return map.toImmutable();
    }

    public ImmutableObjectFloatMap<K> newWithoutKey(K key)
    {
        ObjectFloatHashMap<K> map = ObjectFloatHashMap.newMap();
        map.putAll(this);
        map.removeKey(key);
        return map.toImmutable();
    }

    public ImmutableObjectFloatMap<K> newWithoutAllKeys(Iterable<? extends K> keys)
    {
        ObjectFloatHashMap<K> map = ObjectFloatHashMap.newMap();
        map.putAll(this);
        Iterator<? extends K> iterator = keys.iterator();
        while (iterator.hasNext())
        {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    public float get(Object key)
    {
        return this.delegate.get(key);
    }

    public float getOrThrow(Object key)
    {
        return this.delegate.getOrThrow(key);
    }

    public float getIfAbsent(Object key, float ifAbsent)
    {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    public boolean containsKey(Object key)
    {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(float value)
    {
        return this.delegate.containsValue(value);
    }

    public void forEachValue(FloatProcedure procedure)
    {
        this.delegate.forEachValue(procedure);
    }

    public void forEachKey(Procedure<? super K> procedure)
    {
        this.delegate.forEachKey(procedure);
    }

    public void forEachKeyValue(ObjectFloatProcedure<? super K> objectFloatProcedure)
    {
        this.delegate.forEachKeyValue(objectFloatProcedure);
    }

    public ImmutableObjectFloatMap<K> select(ObjectFloatPredicate<? super K> objectFloatPredicate)
    {
        return this.delegate.select(objectFloatPredicate).toImmutable();
    }

    public ImmutableObjectFloatMap<K> reject(ObjectFloatPredicate<? super K> objectFloatPredicate)
    {
        return this.delegate.reject(objectFloatPredicate).toImmutable();
    }

    public ImmutableObjectFloatMap<K> toImmutable()
    {
        return this;
    }

    public int size()
    {
        return this.delegate.size();
    }

    public boolean isEmpty()
    {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty()
    {
        return this.delegate.notEmpty();
    }

    public Set<K> keySet()
    {
        return UnmodifiableMutableSet.of(this.delegate.keySet());
    }

    public MutableFloatCollection values()
    {
        return UnmodifiableFloatCollection.of(this.delegate.values());
    }

    public LazyIterable<K> keysView()
    {
        return this.delegate.keysView();
    }

    public RichIterable<ObjectFloatPair<K>> keyValuesView()
    {
        return this.delegate.keyValuesView();
    }

    @Override
    public boolean equals(Object obj)
    {
        return this.delegate.equals(obj);
    }

    @Override
    public int hashCode()
    {
        return this.delegate.hashCode();
    }

    @Override
    public String toString()
    {
        return this.delegate.toString();
    }

    public String makeString()
    {
        return this.delegate.makeString();
    }

    public String makeString(String separator)
    {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end)
    {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable)
    {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        this.delegate.appendString(appendable, start, separator, end);
    }

    private Object writeReplace()
    {
        return new ImmutableObjectFloatMapSerializationProxy<K>(this);
    }
}
