/*
 * Copyright (c) 2017 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.bag.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;

import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.LazyCharIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.primitive.ImmutableCharBag;
import org.eclipse.collections.api.bag.primitive.CharBag;
import org.eclipse.collections.api.bag.primitive.MutableCharBag;
import org.eclipse.collections.api.block.function.primitive.CharToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.predicate.primitive.CharPredicate;
import org.eclipse.collections.api.block.procedure.primitive.CharIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.CharProcedure;
import org.eclipse.collections.api.iterator.CharIterator;
import org.eclipse.collections.api.list.primitive.MutableCharList;
import org.eclipse.collections.api.set.primitive.MutableCharSet;
import org.eclipse.collections.impl.bag.mutable.HashBag;
import org.eclipse.collections.impl.bag.mutable.primitive.CharHashBag;
import org.eclipse.collections.impl.factory.primitive.CharBags;
import org.eclipse.collections.impl.iterator.UnmodifiableCharIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyCharIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.CharArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.CharHashSet;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.tuple.primitive.CharIntPair;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;


import net.jcip.annotations.Immutable;


/**
 * ImmutableCharSingletonBag is an optimization for {@link ImmutableCharBag} of size 1.
 * This file was automatically generated from template file immutablePrimitiveSingletonBag.stg.
 *
 * @since 4.0.
 */
@Immutable
final class ImmutableCharSingletonBag implements ImmutableCharBag, Serializable
{
    private static final long serialVersionUID = 1L;

    private final char element1;

    ImmutableCharSingletonBag(char element)
    {
        this.element1 = element;
    }

    public ImmutableCharBag newWith(char element)
    {
        return CharBags.immutable.with(this.element1, element);
    }

    public ImmutableCharBag newWithout(char element)
    {
        return this.element1 == element ? CharBags.immutable.with() : this;
    }

    public ImmutableCharBag newWithAll(CharIterable elements)
    {
        return CharHashBag.newBag(elements).with(this.element1).toImmutable();
    }

    public ImmutableCharBag newWithoutAll(CharIterable elements)
    {
        return elements.contains(this.element1) ? CharBags.immutable.with() : this;
    }

    public int size()
    {
        return 1;
    }

    public boolean isEmpty()
    {
        return false;
    }

    public boolean notEmpty()
    {
        return true;
    }

    public boolean contains(char value)
    {
        return this.element1 == value;
    }

    public boolean containsAll(CharIterable source)
    {
        for (CharIterator iterator = source.charIterator(); iterator.hasNext(); )
        {
            if (this.element1 != iterator.next())
            {
                return false;
            }
        }
        return true;
    }

    public boolean containsAll(char... source)
    {
        for (char value : source)
        {
            if (this.element1 != value)
            {
                return false;
            }
        }
        return true;
    }

    public void forEach(CharProcedure procedure)
    {
        this.each(procedure);
    }

    /**
     * @since 7.0.
     */
    public void each(CharProcedure procedure)
    {
        procedure.value(this.element1);
    }

    public ImmutableCharBag select(CharPredicate predicate)
    {
        return predicate.accept(this.element1) ?
                CharBags.immutable.with(this.element1) :
                CharBags.immutable.empty();
    }

    public ImmutableCharBag selectByOccurrences(IntPredicate predicate)
    {
        return predicate.accept(1) ?
                CharBags.immutable.with(this.element1) :
                CharBags.immutable.empty();
    }

    public ImmutableList<CharIntPair> topOccurrences(int count)
    {
        if (count < 0)
        {
            throw new IllegalArgumentException("Cannot use a value of count < 0");
        }
        if (count == 0)
        {
            return Lists.immutable.empty();
        }
        return Lists.immutable.with(PrimitiveTuples.pair(this.element1, 1));
    }

    public ImmutableList<CharIntPair> bottomOccurrences(int count)
    {
        if (count < 0)
        {
            throw new IllegalArgumentException("Cannot use a value of count < 0");
        }
        if (count == 0)
        {
            return Lists.immutable.empty();
        }
        return Lists.immutable.with(PrimitiveTuples.pair(this.element1, 1));
    }

    public ImmutableCharBag reject(CharPredicate predicate)
    {
        return predicate.accept(this.element1) ?
                CharBags.immutable.empty() :
                CharBags.immutable.with(this.element1);
    }

    public <V> ImmutableBag<V> collect(CharToObjectFunction<? extends V> function)
    {
        return HashBag.newBagWith(function.valueOf(this.element1)).toImmutable();
    }

    public MutableCharList toList()
    {
        return CharArrayList.newListWith(this.element1);
    }

    public int sizeDistinct()
    {
        return 1;
    }

    public int occurrencesOf(char item)
    {
        return this.element1 == item ? 1 : 0;
    }

    public void forEachWithOccurrences(CharIntProcedure charIntProcedure)
    {
        charIntProcedure.value(this.element1, 1);
    }

    public char detectIfNone(CharPredicate predicate, char ifNone)
    {
        return predicate.accept(this.element1) ? this.element1 : ifNone;
    }

    public int count(CharPredicate predicate)
    {
        return predicate.accept(this.element1) ? 1 : 0;
    }

    public boolean anySatisfy(CharPredicate predicate)
    {
        return predicate.accept(this.element1);
    }

    public long sum()
    {
        return this.element1;
    }

    public char min()
    {
        return this.element1;
    }

    public char max()
    {
        return this.element1;
    }

    public char maxIfEmpty(char defaultValue)
    {
        return this.element1;
    }

    public char minIfEmpty(char defaultValue)
    {
        return this.element1;
    }

    public double average()
    {
        return this.element1;
    }

    public double median()
    {
        return this.element1;
    }

    public char[] toSortedArray()
    {
        return new char[]{this.element1};
    }

    public MutableCharList toSortedList()
    {
        return CharArrayList.newListWith(this.element1);
    }

    public boolean noneSatisfy(CharPredicate predicate)
    {
        return !predicate.accept(this.element1);
    }

    public boolean allSatisfy(CharPredicate predicate)
    {
        return predicate.accept(this.element1);
    }

    public <T> T injectInto(T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function)
    {
        return function.valueOf(injectedValue, this.element1);
    }

    @Override
    public boolean equals(Object obj)
    {
        if (obj == this)
        {
            return true;
        }
        if (!(obj instanceof CharBag))
        {
            return false;
        }
        CharBag bag = (CharBag) obj;
        if (bag.size() != 1)
        {
            return false;
        }
        return this.occurrencesOf(this.element1) == bag.occurrencesOf(this.element1);
    }

    @Override
    public int hashCode()
    {
        return (int) this.element1 ^ 1;
    }

    public MutableCharSet toSet()
    {
        return CharHashSet.newSetWith(this.element1);
    }

    public MutableCharBag toBag()
    {
        return CharHashBag.newBagWith(this.element1);
    }

    public ImmutableCharBag toImmutable()
    {
        return this;
    }

    public LazyCharIterable asLazy()
    {
        return new LazyCharIterableAdapter(this);
    }

    public char[] toArray()
    {
        return new char[]{this.element1};
    }

    @Override
    public String toString()
    {
        return '[' + this.makeString() + ']';
    }

    public String makeString()
    {
        return this.makeString(", ");
    }

    public String makeString(String separator)
    {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end)
    {
        Appendable stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return stringBuilder.toString();
    }

    public void appendString(Appendable appendable)
    {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        try
        {
            appendable.append(start);
            appendable.append(String.valueOf(this.element1));
            appendable.append(end);
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
    }

    public CharIterator charIterator()
    {
        return new UnmodifiableCharIterator(CharHashBag.newBagWith(this.element1).charIterator());
    }
}
