/*
 * Copyright (c) 2017 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.set.primitive;

import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.block.function.primitive.FloatToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.FloatPredicate;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.set.MutableSet;

/**
 * This file was automatically generated from template file mutablePrimitiveSet.stg.
 *
 * @since 3.0.
 */
public interface MutableFloatSet extends MutableFloatCollection, FloatSet
{
    MutableFloatSet select(FloatPredicate predicate);

    MutableFloatSet reject(FloatPredicate predicate);

    <V> MutableSet<V> collect(FloatToObjectFunction<? extends V> function);

    MutableFloatSet with(float element);

    MutableFloatSet without(float element);

    MutableFloatSet withAll(FloatIterable elements);

    MutableFloatSet withoutAll(FloatIterable elements);

    MutableFloatSet asUnmodifiable();

    MutableFloatSet asSynchronized();

    /**
     * Returns a frozen copy of this set. A frozen copy is the same thing as an immutable copy without safe-publish guarantees.
     */
    FloatSet freeze();

    /**
     * Returns an immutable copy of this set.
     */
    ImmutableFloatSet toImmutable();
}
