/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl;

import com.koloboke.collect.impl.Containers;
import com.koloboke.collect.impl.InternalByteLongMapOps;
import com.koloboke.collect.map.ByteLongMap;
import com.koloboke.function.ByteLongConsumer;
import com.koloboke.function.ByteLongPredicate;
import java.util.Map;

public final class CommonByteLongMapOps {
    public static boolean containsAllEntries(final InternalByteLongMapOps map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof ByteLongMap) {
            ByteLongMap m2 = (ByteLongMap)another;
            if (map.size() < m2.size()) {
                return false;
            }
            if (m2 instanceof InternalByteLongMapOps) {
                return ((InternalByteLongMapOps)m2).allEntriesContainingIn(map);
            }
            return m2.forEachWhile(new ByteLongPredicate(){

                public boolean test(byte a, long b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry((Byte)e.getKey(), (Long)e.getValue())) continue;
            return false;
        }
        return true;
    }

    public static void putAll(final InternalByteLongMapOps map, Map<? extends Byte, ? extends Long> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof ByteLongMap) {
            if (another instanceof InternalByteLongMapOps) {
                ((InternalByteLongMapOps)another).reversePutAllTo(map);
            } else {
                ((ByteLongMap)another).forEach(new ByteLongConsumer(){

                    public void accept(byte key, long value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<? extends Byte, ? extends Long> e : another.entrySet()) {
                map.justPut(e.getKey(), e.getValue());
            }
        }
    }

    private CommonByteLongMapOps() {
    }
}

