package org.simantics.scl.runtime.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.List;

import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.function.Function;
import org.simantics.scl.runtime.reporting.SCLReporting;
import org.simantics.scl.runtime.tuple.Tuple0;

public class AsyncUtils {
    public static void runAsync(Function f) {
        SCLContext context = SCLContext.createDerivedContext();
        new Thread() {
            @Override
            public void run() {
                SCLContext.push(context);
                try {
                    f.apply(Tuple0.INSTANCE);
                } catch(Exception e) {
                    StringWriter sw = new StringWriter();
                    e.printStackTrace(new PrintWriter(sw));
                    SCLReporting.printError(sw.toString());
                } finally {
                    SCLContext.pop();
                }
            }
        }.start();
    }
    
    public static List<Object> pmap(Function f, List<Object> l) {
        return Arrays.asList(l.parallelStream().map(a -> f.apply(a)).toArray());
    }
}
