/*******************************************************************************
 * Copyright (c) 2017 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.issues.common;

import java.util.Set;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PossibleVariable;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.issues.ontology.IssueResource;

import gnu.trove.set.hash.THashSet;

/**
 * @author Tuukka Lehtonen
 * @since 1.27
 */
public class DynamicIssueSources extends ResourceRead<Set<Variable>> {

    public DynamicIssueSources(Resource project) {
        super(project);
    }

    @Override
    public Set<Variable> perform(ReadGraph graph) throws DatabaseException {
        IssueResource ISSUE = IssueResource.getInstance(graph);
        Set<Variable> result = new THashSet<>();
        for (Resource source : graph.syncRequest(new ActiveProjectIssueSources(resource, ISSUE.DynamicIssueSource))) {
            boolean selected = graph.hasStatement(source, ISSUE.IssueSource_Selected);
            if (!selected)
                continue;
            Variable v = graph.syncRequest(new PossibleVariable(source));
            if (v != null)
                result.add(v);
        }
        return result;
    }

}
