package org.simantics.fileimport;

import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;

import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteResultRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.modeling.ModelingUtils;

public class LibraryFolderFileImport extends SimanticsResourceFileImport {

    private static final Map<String, String> ALLOWED_EXTENSIONS = Collections.singletonMap(FileImportService.FOLDER, FileImportService.FOLDER);

    @Override
    public Map<String, String> allowedExtensionsWithFilters() {
        return ALLOWED_EXTENSIONS;
    }

    @Override
    public Optional<Resource> perform(Resource parent, Path file) throws Exception {
        final String name = file.getFileName().toString();
        return Optional.of(Simantics.getSession().syncRequest(new WriteResultRequest<Resource>() {

            @Override
            public Resource perform(WriteGraph graph) throws DatabaseException {
                return ModelingUtils.createLibrary(graph, parent, name);
            }
        }));
    }
    
    @Override
    public Resource defaultParentResource() {
        return Simantics.getProjectResource();
    }
}
