package org.simantics.fileimport;

import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;

import org.simantics.db.Resource;

/**
 * Base interface for performing file imports. 
 * 
 * Usually with Simantics products every file that will be imported will become 
 * a resource in the Simantics database. For these cases see {@link SimanticsResourceFileImport}
 * 
 * @author Jani Simomaa
 *
 */
public interface IGenericFileImport {

    /**
     * Performs the import for the given file
     * 
     * @param file Path to file to import
     * @return Optional string which will be the identifier of the imported file which can later be used for removing the imported entity
     * @throws Exception
     */
    Optional<String> perform(Path file) throws Exception;

    Optional<Resource> perform(Resource parent, Path file) throws Exception;
    
    /**
     * Remove the entity
     * 
     * @param identifier String identifier which can be used to remove the imported entity
     */
    void remove(String identifier) throws Exception;
    
    /**
     * Returns a key-value map for file extensions this importer can handle
     * 
     * @return Map<String, String> allowed extensions this service can handle. Key is the extension e.g. <code>.sharedLibrary</code> and the value is the description of the extension
     */
    Map<String, String> allowedExtensionsWithFilters();

}
