package org.simantics.document.linking.report.templates;

import java.util.List;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.document.linking.ontology.DocumentLink;

class SourceParentHierarchyWithPropComparator extends ResourceNameComparator {
	DocumentLink sl;
	
	public SourceParentHierarchyWithPropComparator(ReadGraph graph, Resource model) {
		super(graph,model);
		sl = DocumentLink.getInstance(graph);
	}
	@Override
	public int compare(Resource o1, Resource o2) {
		try {
			Resource r1 = graph.getSingleObject(o1, sl.hasSource_Inverse);
			Resource r2 = graph.getSingleObject(o2, sl.hasSource_Inverse);
			List<Resource> path1 = getPath(r1);
			List<Resource> path2 = getPath(r2);
			int count = Math.min(path1.size(), path2.size());
			int i = 0;
			int comp = 0;
			for (; i < count; i++) {
				comp = super.compare(path1.get(i), path2.get(i));
				if (comp != 0)
					return comp;
			}
			if (path1.size() < path2.size())
				return -1;
			else if (path2.size() > path1.size())
				return 1;
			
			Resource rel1 = graph.getPossibleObject(o1, sl.consernsRelation);
			Resource rel2 = graph.getPossibleObject(o2, sl.consernsRelation);
			if (rel1 != null) {
				if (rel2 != null)
					return super.compare(rel1,rel2);
				return 1;
			} else if (rel2 != null)
				return -1;
			return 0;
			
		} catch (Exception e) {
			return 0;
		}
		
	}
}