package org.simantics.document.linking.report.evaluator;

import java.util.Collection;

import org.simantics.annotation.ontology.AnnotationResource;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.layer0.Layer0;
import org.simantics.ui.SimanticsUI;

/**
 * Copy-paste from org.simantics.diagram.function.PredefinedVariables (removed diagram specific stuff)
 * 
 * 
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 *
 */
public class PredefinedVariables {
	public static final String root = "root";
	public static final String project = "project";
	public static final String model = "model";
	public static final String template = "template";
	public static final String current = ".";


	private static PredefinedVariables factory = new PredefinedVariables();
	
	public static PredefinedVariables getInstance(){
		return factory;
	}
	
	public static void setFactory(PredefinedVariables factory){
		PredefinedVariables.factory = factory;
	}
	
    Resource connectedComponent = null;
    




	public static Resource getAnnotation(ReadGraph graph, Resource res) throws DatabaseException {
		Layer0 L0 = Layer0.getInstance(graph);
        Collection<Resource> children = graph.getObjects(res, L0.ConsistsOf);
        Resource anno = null;
        AnnotationResource ANNO = AnnotationResource.getInstance(graph);
        for (Resource child:children){
        	if (graph.isInstanceOf(child, ANNO.Annotation)){
        		anno = child;
        		break;
        	}
        }
        return anno;
	} 



	public Resource getPredefinedResource(ReadGraph graph, Variable selection, String id) throws DatabaseException {
		Resource predefined = null;
        if (id.equals(root))
        	predefined = graph.getRootLibrary();
        else if (id.equals(project))
        	predefined = SimanticsUI.getProject().get();
        else if (id.equals(model))
        	predefined = Variables.getModel(graph, selection);
        else if (id.equals(template)){
//			Resource composite = selection.getRepresents(graph);
//			if (composite == null)
//				return null;
//			ModelingResources MOD = ModelingResources.getInstance(graph);
//            Template2dResource TEPLATE2D = Template2dResource.getInstance(graph);
//			Resource diagram = graph.getPossibleObject(composite, MOD.CompositeToDiagram);
//			if (diagram == null)
//				return null;
//			predefined = graph.getPossibleObject(diagram, TEPLATE2D.HasDrawingTemplate);
        }
        else if (id.equals(current))
        	predefined =  selection.getRepresents(graph);
        return predefined;
	}
	
	public Variable getPredefinedVariable(ReadGraph graph, Variable selection, String id) throws DatabaseException {
		Resource predefined = this.getPredefinedResource(graph, selection, id);
		if (predefined == null)
			return null;
		
        Variable v = selection;
        //Variable test = Variables.getPossibleVariable(graph, "http://Projects/Development%20Project/Model/Configuration/NewAutomationDiagram2/__CONTAINER__/__DIAGRAM__/4");
        if (predefined != null)
            v = graph.adapt(predefined, Variable.class);
        return v;
	}
	
	public Variable getVariable(ReadGraph graph, String path, Resource converter, Variable selection) throws DatabaseException {
        if (path == null)
        	return null;
        int colonInx = path.indexOf(':');
        int firstSlash = path.indexOf('/');
        int firstHash = path.indexOf('#');
        int firstFlashInx = firstSlash;
        if(firstFlashInx == -1) firstFlashInx = firstHash;
        else {
        	if(firstHash > -1 && firstHash < firstFlashInx) firstFlashInx = firstHash;
        }

        String predefined = null;
        String relativePath = null;

        // if scheme is followed by absolute uri
        // for examples:
        // pre:/model/Library/logo.svg#data -- get under model
        // pre:/./Library/logo.svg#data-- get under composite which corresponds the diagram
        // pre:/project/Library/FORTUM_LOGO_CMYK.svg#data -- get under project
        // pre:/root/Library/FORTUM_LOGO_CMYK.svg#data -- get under root
        
        if (colonInx != -1 && firstFlashInx != -1 && colonInx+1 == firstFlashInx && path.length() > firstFlashInx+1){
            String scheme = path.substring(0, colonInx);
            String absPath = path.substring(firstFlashInx+1);
            if (scheme.equals("pre")){
                int endOfPredefined1 = absPath.indexOf('/');
                int endOfPredefined2 = absPath.indexOf('#');
                if (endOfPredefined1 == -1 && endOfPredefined2 == -1)
                    predefined = absPath;
                if (endOfPredefined1 == -1 && endOfPredefined2 != -1)
                    predefined = absPath.substring(0, endOfPredefined2);
                if (endOfPredefined1 != -1 && endOfPredefined2 == -1)
                    predefined = absPath.substring(0, endOfPredefined1);
                if (endOfPredefined1 != -1 && endOfPredefined2 != -1){
                    if (endOfPredefined2 < endOfPredefined1)
                        endOfPredefined1 = endOfPredefined2;
                    predefined = absPath.substring(0, endOfPredefined1);
                }
                relativePath = absPath.substring(predefined.length());
            }
        }

        //Variable activeVariable = ScenegraphLoaderUtils.getPossibleVariableSelection(graph, context);
        if (selection == null)
        	return null;
        
        Variable v = selection;
        if (predefined != null)
        	v = getPredefinedVariable(graph, selection, predefined);

        if (v == null)
            return null;

        Variable property = null;
        if (relativePath != null){
        	if (relativePath.startsWith("/."))
        		relativePath = relativePath.substring(1);
            property = v.browsePossible(graph, relativePath);
        }
        else
            property = v.browsePossible(graph, path);
        return property;
    }

}
