package org.simantics.document.linking.report.evaluator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.document.linking.Activator;
import org.simantics.document.linking.ontology.DocumentLink;
import org.simantics.document.linking.report.DocumentLine;
import org.simantics.objmap.graph.annotations.OrderedSetType;
import org.simantics.objmap.graph.annotations.RelatedGetValue;
import org.simantics.objmap.graph.annotations.RelatedSetValue;

/**
 * And node combines contents of the child nodes with configurable separator (default " ")
 * 
 * If all children return null, the return value is null.
 * 
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 *
 */
@OrderedSetType(DocumentLink.URIs.EvaluatorTree_And)
public class And extends EvaluatorNode implements StringEditableNode{
	
	String separator;
	
	
	public And() {
		separator = " ";
	}
	
	public And(String separator) {
		this.separator = separator;
	}
	
	public void setSeparator(String separator) {
		this.separator = separator;
	}
	
	public String getSeparator() {
		return separator;
	}
	
	
	@Override
	public String getValue(ReadGraph graph, Variable variable, Map<Object, Object> context) throws DatabaseException {
		String s = "";
		for (int i = 0 ; i < children.size(); i++) {
			String s2 = children.get(i).getValue(graph, variable, context);
			if (s2 != null) {
				s+= s2;
				if (i < children.size()-1)
					s+=separator;
			}
		}
		if (s.length() == 0)
			return null;
		return s;
	}
	
	@Override
	public List<DocumentLine> getLines(ReadGraph graph,	Variable variable, Map<Object, Object> context) throws DatabaseException {
		List<DocumentLine> result = new ArrayList<DocumentLine>();
		for (int i = 0 ; i < children.size(); i++) {
			List<DocumentLine> list = children.get(i).getLines(graph, variable, context);
			for (int j = 0; j < list.size(); j++) {
				DocumentLine line = list.get(j); 
				if (j <= result.size()) {
					result.add(line);
				} else {
					DocumentLine extLine = result.get(j);
					String combined = extLine.getLine() + separator + line.getLine();
					Map<Object,Object> combinedSet = new HashMap<Object, Object>();
					combinedSet.putAll(extLine.getHints());
					combinedSet.putAll(line.getHints());
					
					result.set(j, new DocumentLine(combined,combinedSet));
				}
			}
		}
		return result;
	}
	

	@Override
	public String toString() {
		return "and " + "(" + separator +")" ;
	}
	
	@RelatedGetValue(DocumentLink.URIs.EvaluatorTree_HasValue)
	@Override
	public String getValue() {
		return separator;
	}
	
	@Override
	public String setValue(String value) {
		separator = value;
		return null;
	}
	
	@RelatedSetValue(DocumentLink.URIs.EvaluatorTree_HasValue)
	public void _setValue(String value) {
		separator = value;
	}
	
	@Override
	public EvaluatorItem copy() {
		And a = new And(separator);
		copyChildren(a);
		return a;
	}
	
	@Override
	public ImageDescriptor getImage() {
		return Activator.imageDescriptorFromPlugin("com.famfamfam.silk", "icons/text_columns.png");
	}

}
