package org.simantics.document.linking.ge;

import java.util.Arrays;
import java.util.Comparator;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.dialogs.ListDialog;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.document.linking.ontology.DocumentLink;
import org.simantics.document.linking.utils.SourceLinkUtil;
import org.simantics.ui.SimanticsUI;
import org.simantics.ui.workbench.editor.EditorAdapter;
import org.simantics.ui.workbench.editor.EditorRegistry;
import org.simantics.utils.ui.ExceptionUtils;

public class ShowDocumentWithAction implements ActionFactory{
	
	
	@Override
	public Runnable create(Object target) {
		if (!(target instanceof Variable))
			return null;
		final Variable v = (Variable)target;
		

		return new Runnable() {
			
			@Override
			public void run() {
				SimanticsUI.getSession().asyncRequest(new ReadRequest() {
					
					@Override
					public void run(ReadGraph graph) throws DatabaseException {
						DocumentLink sl = DocumentLink.getInstance(graph);
						Resource t = v.getPossibleRepresents(graph);
						if (!graph.isInstanceOf(t, sl.Source))
							return;
						final Resource reference = SourceLinkUtil.getReferredDocument(graph, t);
						if (reference == null)
							return;
						final EditorAdapter[] adapters = EditorRegistry.getInstance().getAdaptersFor(graph, reference);
						if (adapters.length == 0)
							return;
						Arrays.sort(adapters, new Comparator<EditorAdapter>() {
							@Override
							public int compare(EditorAdapter o1, EditorAdapter o2) {
								return o1.getPriority() - o2.getPriority();
							}
						});
						
						Display.getDefault().asyncExec(new Runnable() {
							
							@Override
							public void run() {
								try {
									ListDialog dialog = new ListDialog(Display.getCurrent().getActiveShell());
									dialog.setContentProvider(new ArrayContentProvider());
									dialog.setLabelProvider(new EditorAdapterLabelProvider());
									dialog.setInput(adapters);
									dialog.setTitle("Open with");
									if (dialog.open() != ListDialog.OK)
										return;
									EditorAdapter adapter = (EditorAdapter)dialog.getResult()[0];
									
									adapter.openEditor(reference);
								} catch (Exception e) {
									ExceptionUtils.logAndShowError("Cannot open editor", e);
								}
							}
						});

						
					}
				});
				
			}
		};

		
	}
	
	private static class ArrayContentProvider implements IStructuredContentProvider {
		public Object[] getElements(Object inputElement) {
			return (Object[])inputElement;
		};
		
		@Override
		public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
			
		}
		@Override
		public void dispose() {
			
		}
	}
	
	private static class EditorAdapterLabelProvider extends BaseLabelProvider implements ILabelProvider {
		private LocalResourceManager localResourceManager;
		
		public EditorAdapterLabelProvider() {
			localResourceManager = new LocalResourceManager(JFaceResources.getResources());
		}
		@Override
		public Image getImage(Object element) {
			EditorAdapter adapter = (EditorAdapter)element;
			return localResourceManager.createImage(adapter.getIcon());
		}
		
		@Override
		public String getText(Object element) {
			EditorAdapter adapter = (EditorAdapter)element;
			return adapter.getName();
		}
		
		@Override
		public void dispose() {
			localResourceManager.dispose();
			super.dispose();
		}
	}

}
