/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui;




/**
 * This is an interface for resolvers whose purpose is to adapt data stored in
 * Eclipse workbench's {@link ISelection} instances into the input data objects
 * that are stored within GraphExplorer's {@link NodeContext} instances.
 * 
 * <p>
 * This interface is needed to externalize the logic of converting external
 * Workbench selections into GraphExplorer selections, so that GraphExplorer
 * itself can stay generic.
 * </p>
 * 
 * @author Tuukka Lehtonen
 */
public interface SelectionDataResolver {

    /**
     * Converts the specified selection element into the real data object contained by
     * the selection to allow the GraphExplorer to generically look for those
     * data objects within the input objects stored by {@link NodeContext}'s
     * (see {@link BuiltinKeys#INPUT} and
     * {@link NodeContext#getConstant(org.simantics.browsing.ui.NodeContext.ConstantKey)}
     * ).
     * 
     * @param selection a workbench selection
     * @return an array of data objects resolved from the specified selection or
     *         <code>null</code> if nothing could be resolved.
     */
    Object resolve(Object selectionElement);

}
