/*******************************************************************************
 * Copyright (c) 2010, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.model.children;

import java.util.Collection;
import java.util.Collections;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;

public class ConstantChildRule implements ChildRule {
    Collection<Resource> children;
    
    public ConstantChildRule(Collection<Resource> children) {
        this.children = children;
    }
    
    @Override
    public Collection<?> getChildren(ReadGraph graph, Object parent) throws DatabaseException {
       return children;
    }
    
    @Override
    public Collection<?> getParents(ReadGraph graph, Object child) throws DatabaseException {
        return Collections.emptyList();        
    }

    @Override
    public boolean isCompatible(Class<?> contentType) {
        return true;
    }
}
