/*
 * Copyright (c) 2017 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.set.primitive;

import org.eclipse.collections.api.BooleanIterable;
import org.eclipse.collections.api.block.function.primitive.BooleanToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BooleanPredicate;
import org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;
import org.eclipse.collections.api.set.MutableSet;

/**
 * This file was automatically generated from template file mutablePrimitiveSet.stg.
 *
 * @since 3.0.
 */
public interface MutableBooleanSet extends MutableBooleanCollection, BooleanSet
{
    MutableBooleanSet select(BooleanPredicate predicate);

    MutableBooleanSet reject(BooleanPredicate predicate);

    <V> MutableSet<V> collect(BooleanToObjectFunction<? extends V> function);

    MutableBooleanSet with(boolean element);

    MutableBooleanSet without(boolean element);

    MutableBooleanSet withAll(BooleanIterable elements);

    MutableBooleanSet withoutAll(BooleanIterable elements);

    MutableBooleanSet asUnmodifiable();

    MutableBooleanSet asSynchronized();

    /**
     * Returns a frozen copy of this set. A frozen copy is the same thing as an immutable copy without safe-publish guarantees.
     */
    BooleanSet freeze();

    /**
     * Returns an immutable copy of this set.
     */
    ImmutableBooleanSet toImmutable();
}
