package org.simantics.scl.db;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.simantics.Simantics;
import org.simantics.application.arguments.Arguments;
import org.simantics.application.arguments.IArgumentFactory;
import org.simantics.application.arguments.IArguments;
import org.simantics.application.arguments.SimanticsArguments;
import org.simantics.scl.compiler.commands.CommandSession;
import org.simantics.scl.osgi.SCLOsgi;
import org.simantics.scl.runtime.reporting.SCLReportingHandler;

public class SCLScriptRunnerApplication implements IApplication {

	@Override
	public Object start(IApplicationContext context) throws Exception {
		try {
            String[] args = (String[])context.getArguments().get("application.args");
            IProgressMonitor progress = new NullProgressMonitor();
            Simantics.startUpHeadless(parseArguments(args), progress);
            runSCLFromStdin();
            Simantics.shutdown(progress);
            return IApplication.EXIT_OK;
        } catch(Throwable t) {
            t.printStackTrace();
            throw (Exception)t;
        } finally {
            System.exit(0);
        }
	}
	
	private void runSCLFromStdin() throws Exception {
		BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
		CommandSession commandSession = new CommandSession(SCLOsgi.MODULE_REPOSITORY,
		        SCLReportingHandler.DEFAULT_WITHOUT_ECHO);
		try {
			while(true) {
				String line = input.readLine();
				if(line == null)
					break;
				if(line.isEmpty())
					continue;
				commandSession.execute(line);
			}
		} catch(IOException e) {
			e.printStackTrace();
		}		
	}

	private IArguments parseArguments(String[] args) {
		IArgumentFactory<?>[] accepted = {
				SimanticsArguments.RECOVERY_POLICY_FIX_ERRORS,
				SimanticsArguments.ONTOLOGY_RECOVERY_POLICY_REINSTALL,
				SimanticsArguments.SERVER,
				SimanticsArguments.LOCAL_SERVER_PORT,
				SimanticsArguments.DISABLE_INDEX,
				SimanticsArguments.DATABASE_ID,
		};
		IArguments result = Arguments.parse(args, accepted);
		return result;
	}
	
	@Override
	public void stop() {
	}

}
